% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBars.R
\name{plotBars}
\alias{plotBars}
\title{Barplots of reference and model data with same unit}
\usage{
plotBars(mod.path.list, modelIDs, variableNames, referenceNames,
  showFractions = FALSE, targetVariable = "RNS",
  ofileName = "barplot.pdf", plot.width = 12, plot.height = 8,
  outputDir = FALSE, subcaption = FALSE)
}
\arguments{
\item{mod.path.list}{A list with paths for each model run, e.g. mod.path.list <- list(mod01.path, mod02.path, mod03.path).
The respective folders must each contain the file 'metricsTable' produced by the function \link{scores.tables}.}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{variableNames}{Names of variables that should be plotted, e.g.  c('HFG', 'HFLS', 'HFSS', 'RNS')}

\item{referenceNames}{Names of reference data that should be plotted, e.g. c('FLUXNET', 'CLASS')}

\item{showFractions}{Logical. If set to TRUE, the Figure will show fractional values,
such as the fractions of net surface radiation that are converted into heat fluxes.}

\item{targetVariable}{A string that gives the variable for which fractions are
computed, e.g. 'RNS' for net surface radiation. Only relevant if showFractions = TRUE.}

\item{ofileName}{A string that gives the output file name, e.g. 'barplot.pdf'}

\item{plot.width}{Number that gives the plot width, e.g. 12}

\item{plot.height}{Number that gives the plot height, e.g. 8}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{subcaption}{Logical. If TRUE then the subcaptions (a) and (b) are added.}
}
\value{
Barplots of annual mean values annual mean values for a selection of variables and reference data.
}
\description{
This function produces barplots of annual mean values for a selection of variables and reference data.
The user may choose to plot both, absolute and fractional values. A typical application
is a barplot for variables related to the surface energy balance.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- system.file('extdata/SIMod01', package = 'amber')
mod02.path <- system.file('extdata/SIMod02', package = 'amber')

mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')
variableNames <- c('HFG', 'HFLS', 'HFSS', 'RNS')
referenceNames <- c('FLUXNET', 'CLASS')

plotBars(mod.path.list, modelIDs, variableNames, referenceNames,
showFractions = TRUE, targetVariable = 'RNS', ofileName = 'barplot.pdf',
plot.width = 5, plot.height = 5, outputDir = FALSE)

}
