% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.compare.ensemble.R
\name{scores.compare.ensemble}
\alias{scores.compare.ensemble}
\title{Summarize scores from multiple model runs in single figure.}
\usage{
scores.compare.ensemble(mod.path.list = mod.path.list,
  modelIDs = modelIDs, myVariables = myVariables, plot.width = 10,
  plot.height = 10, myMargin = c(12, 0, 3, 0), outputDir = FALSE)
}
\arguments{
\item{mod.path.list}{A list with paths for each model run, e.g. mod.path.list <- list(mod01.path, mod02.path, mod03.path)}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{myVariables}{An R object with variable names of variables that should be included in table, e.g. c('GPP', 'RECO', 'NEE')}

\item{plot.width}{Number that gives the plot width, e.g. 6}

\item{plot.height}{Number that gives the plot height, e.g. 5}

\item{myMargin}{An R object that gives the figure margins, e.g. c(4, 13, 3, 4)}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
A figure in PDF format that shows the ensemble scores,
the total score range, the model with the lowest score and the model with the highest score.
}
\description{
This function produces a figure that summarizes score values from
multiple model runs. The figure has four columns, which give the multi-model
mean scores, the total score range, the model with the lowest score and the
model with the highest score. The respective inputs are created by the functions
\link{scores.fluxnet.csv} or \link{scores.fluxnet.nc},
\link{scores.grid.notime},
\link{scores.grid.time}, and
\link{scores.runoff}.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

mod01.path <- system.file('extdata/model01', package = 'amber')
mod02.path <- system.file('extdata/model02', package = 'amber')
mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')
myVariables <- c('GPP', 'BURNT')
#myVariables <- c('RNS', 'RSS', 'RLS', 'ALBS', 'HFLS', 'HFSS', 'HFG', 'GPP', 'RECO',
#'NEE', 'FIRE', 'AGB', 'CVEG', 'CSOIL', 'LAI', 'BURNT', 'SNW', 'MRSLL', 'MRRO')

scores.compare.ensemble(mod.path.list = mod.path.list, modelIDs = modelIDs,
myVariables = myVariables, plot.width = 9.3, plot.height = 10,
myMargin = c(12, 0, 3, 0), outputDir = FALSE)

}
