% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalCycleIrreg.R
\name{seasonalCycleIrreg}
\alias{seasonalCycleIrreg}
\title{Zonal mean plots of model and reference data on an irregular grid}
\usage{
seasonalCycleIrreg(long.name, nc.mod, nc.ref, mod.id, ref.id,
  unit.conv.mod, unit.conv.ref, variable.unit, outlier.factor = 1000,
  my.projection = "+proj=ob_tran +o_proj=longlat +o_lon_p=83. +o_lat_p=42.5 +lon_0=263.",
  plot.width = 8, plot.height = 3.8, numCores = 2,
  timeInt = "month", outputDir = FALSE)
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{nc.mod}{A string that gives the path and name of the netcdf file that contains the model output, e.g. '/home/model_gpp.nc'}

\item{nc.ref}{A string that gives the path and name of the netcdf file that contains the reference data output, e.g. '/home/reference_gpp.nc'}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CLASSIC'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{unit.conv.ref}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{outlier.factor}{A number that is used to define outliers, e.g. 10.
Plotting raster objects that contain extreme outliers lead to figures where
most grid cells are presented by a single color since the color legend covers
the entire range of values. To avoid this, the user may define outliers that
will be masked out and marked with a red dot. Outliers are all values that
exceed the interquartile range multiplied by the outlier factor defined here.}

\item{my.projection}{A string that defines the projection of the irregular grid}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{numCores}{An integer that defines the number of cores, e.g. 2}

\item{timeInt}{A string that gives the time interval of the model data, e.g. 'month' or 'year'}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
A plot in PDF format that gives the (a) global mean time series and
(b) the climatological mean seasonal cycle of model and reference data.
The bold line presents the spatial mean values and the shaded area gives the
total range caused by interannual variability.
}
\description{
This function plots the mean seasonal cycle and corresponding inter-quartile
range of model and reference data that are stored on an irregular grid.
}
\examples{
\donttest{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

long.name <- 'Gross primary productivity'
nc.mod <- system.file('extdata/modelRotated', 'gpp_monthly.nc', package = 'amber')
nc.ref <- system.file('extdata/referenceRotated', 'gpp_GBAF_rotated.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'GBAF' # give reference dataset a name
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
unit.conv.ref <- 86400*1000 # optional unit conversion for reference data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)

seasonalCycleIrreg(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit)
} #donttest
}
