

aml.estimate<- function(fit, marker, response, kin){
### this function calculate the genetic values (predicted phenotype values) using the fit of amltest()
### fit should be an object generated by amltest()
### marker, y, and kin are the input used by amltest()
###  The value is a vector of predicted values (genetic values).

  if(sum(names(fit)!=c("estimate", "AIC", "BIC", "EBIC", "vars", "mcount"))>0) stop("fit should be an object generated by amltest()")
  selmarker<- marker[,as.vector(fit$estimate[,1])]
  selmarker<-sweep(selmarker, 2,apply(selmarker, 2, mean),"-")
  fixpred<- mean(response)+as.matrix(selmarker)%*% as.vector(fit$estimate[,2])
  vars<-fit$vars
  gmat<- vars[1]*kin
  sigma<- gmat+ vars[1]*vars[2]*diag(rep(1,length(response)))
  uhat<- gmat%*%solve(sigma)%*%(response-fixpred)
  pred<- fixpred+uhat
  return(pred)

}



