% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DZ.AMMI.R
\name{DZ.AMMI}
\alias{DZ.AMMI}
\title{Zhang's D Parameter}
\usage{
DZ.AMMI(model, n, alpha = 0.05, ssi.method = c("farshadfar", "rao"), a = 1)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{n}{The number of principal components to be considered for computation.
The default value is the number of significant IPCs.}

\item{alpha}{Type I error probability (Significance level) to be considered
to identify the number of significant IPCs.}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}
}
\value{
A data frame with the following columns:  \item{DZ}{The DZ values.}
  \item{SSI}{The computed values of simultaneous selection index for yield
  and stability.} \item{rDZ}{The ranks of DZ values.} \item{rY}{The ranks of
  the mean yield of genotypes.} \item{means}{The mean yield of the
  genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{DZ.AMMI} computes the Zhang's D Parameter values or AMMI statistic
coefficient or AMMI distance or AMMI stability index
(\mjseqn{\textrm{D}_{\textrm{z}}})
\insertCite{zhang_analysis_1998}{ammistability} considering all significant
interaction principal components (IPCs) in the AMMI model. It is the distance
of IPC  point  from  origin  in space. Using
\mjseqn{\textrm{D}_{\textrm{z}}}, the Simultaneous Selection Index for Yield
and Stability (SSI) is also calculated according to the argument
\code{ssi.method}. \loadmathjax
}
\details{
The Zhang's D Parameter value (\mjseqn{D_{z}})
\insertCite{zhang_analysis_1998}{ammistability} is computed as follows:

\mjsdeqn{D_{z} = \sqrt{\sum_{n=1}^{N'}\gamma_{in}^{2}}}

Where, \mjseqn{N'} is the number of significant IPCs (number of IPC that were
retained in the AMMI model via F tests); and \mjseqn{\gamma_{in}} is the
eigenvector value for \mjseqn{i}th genotype.
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

# ANOVA
model$ANOVA

# IPC F test
model$analysis

# Mean yield and IPC scores
model$biplot

# G*E matrix (deviations from mean)
array(model$genXenv, dim(model$genXenv), dimnames(model$genXenv))

# With default n (N') and default ssi.method (farshadfar)
DZ.AMMI(model)

# With n = 4 and default ssi.method (farshadfar)
DZ.AMMI(model, n = 4)

# With default n (N') and ssi.method = "rao"
DZ.AMMI(model, ssi.method = "rao")

# Changing the ratio of weights for Rao's SSI
DZ.AMMI(model, ssi.method = "rao", a = 0.43)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[agricolae]{AMMI}}, \code{\link[ammistability]{SSI}}
}
