% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_to_sf.R
\name{hr_to_sf}
\alias{hr_to_sf}
\title{Convert}
\usage{
hr_to_sf(x, col, ..., level = 0.95)
}
\arguments{
\item{x}{A \code{tibble} with a \code{list column} with individual home ranges.}

\item{col}{The column where the home}

\item{...}{Additional columns that should be transfered to the new \code{tible}.}

\item{level}{\code{[numeric(1)=0.95]{0-1}} \cr The home-range level.}
}
\value{
A \code{data.frame} with a simple feature column (from the \code{sf}) package.
}
\description{
Convert
}
\examples{

data("amt_fisher")
hr <- amt_fisher \%>\% nest(data = -id) \%>\%
  mutate(hr = map(data, hr_mcp), n = map_int(data, nrow)) \%>\%
  hr_to_sf(hr, id, n)

hr <- amt_fisher \%>\% nest(data = -id) \%>\%
  mutate(hr = map(data, hr_kde), n = map_int(data, nrow)) \%>\%
  hr_to_sf(hr, id, n)


\dontrun{
ggplot(hr) + geom_sf()

}

}
