% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{methods}
\name{setLoggerDetails}
\alias{setLoggerDetails}
\alias{setLoggerDetails,BaseAnalysisPipeline-method}
\title{Sets the logger configuration for the pipeline}
\usage{
setLoggerDetails(object, target = "console",
  targetFile = "pipelineExecution.out", layout = "layout.simple")

\S4method{setLoggerDetails}{BaseAnalysisPipeline}(object,
  target = "console", targetFile = "pipelineExecution.out",
  layout = "layout.simple")
}
\arguments{
\item{object}{A Pipeline object}

\item{target}{A string value. 'console' for appending to console, 'file' for appending to a file, or 'console&file' for both}

\item{targetFile}{File name of the log file in case the target is 'file'}

\item{layout}{Specify the layout according to 'futile.logger' package convention}
}
\description{
Sets the logger configuration for the pipeline
}
\details{
This function sets the logger configuration for the pipeline.
}
\examples{
library(analysisPipelines)
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% setLoggerDetails(target = "file",
 targetFile = "pipeline.out") -> pipelineObj
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
