% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-batch-eda-utilities.R
\name{multiVarOutlierPlot}
\alias{multiVarOutlierPlot}
\title{Multi-Variate Outlier Plot}
\usage{
multiVarOutlierPlot(data, depCol, indepCol, sizeCol, priColor = "blue",
  optionalPlots = 0, cutoffValue = 0.05)
}
\arguments{
\item{data}{the dataframe that needs to be loaded}

\item{depCol}{the name of column which is to be identified as dependent column}

\item{indepCol}{the name of an independent column}

\item{sizeCol}{the name of column used to define the size of point in plots}

\item{priColor}{the primary color for the plots}

\item{optionalPlots}{A Flag for optional plots}

\item{cutoffValue}{A p-alue cutoff for detecting outliers}
}
\value{
Outliers plot
}
\description{
Multi-Variate Outlier Plot
}
\details{
Multivaraite outlier plot using the selected columns from the dataframe
}
\examples{
\dontrun{
multiVarOutlierPlot(data = iris, depCol = "Sepal.Length",
   indepCol = "Sepal.Width", sizeCol = "Petal.Length")
}
}
\seealso{
Other Package EDA Utilites functions: \code{\link{CheckColumnType}},
  \code{\link{bivarPlots}},
  \code{\link{correlationMatPlot}},
  \code{\link{getDatatype}}, \code{\link{ignoreCols}},
  \code{\link{outlierPlot}},
  \code{\link{univarCatDistPlots}}
}
\concept{Package EDA Utilites functions}
