% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getSegmentInfo}
\alias{getSegmentInfo}
\title{getSegmentInfo}
\usage{
getSegmentInfo(auth, report.suite.id)
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}

\item{report.suite.id}{ID number (as numeric or character) of datasuite. Can be obtained using the function \code{getDatasuiteInfo} (column \code{d.s.id})}
}
\value{
R data frame containing one row per segment with segment id, segment name and the datasuite id (reportSuiteId)
}
\description{
List all the segments for a specific datasuite
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth))
auth <- authenticate("https://demo.anametrix.com/api", username, password)
segment.df <- getSegmentInfo(auth, 10385)

}
\seealso{
Other metadata functions: \code{\link{getAccountInfo}},
  \code{\link{getDatasuiteInfo}},
  \code{\link{getDetailedInfo}},
  \code{\link{getReplacementNames}},
  \code{\link{getTableInfo}}, \code{\link{getVariableInfo}}
}

