% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{compare_flags}
\alias{compare_flags}
\title{Joins and reformats two animal data frames for the purpose of flag comparison}
\usage{
compare_flags(
  correct,
  candidate,
  use_elev = TRUE,
  use_slope = TRUE,
  has_flags = FALSE,
  dropped_flag = NULL
)
}
\arguments{
\item{correct}{reference data frame}

\item{candidate}{df to be compared to the reference}

\item{use_elev}{logical, whether to include elevation in comparison, defaults to true}

\item{use_slope}{logical, whether to include slope in comparison, defaults to true}

\item{has_flags}{logical, whether correct data frame has predefined flags, defaults to false}

\item{dropped_flag}{dropped flag column, must be defined when has_flags is true, otherwise null}
}
\value{
joined and reformatted data frame
}
\description{
Joins and reformats two animal data frames for the purpose of flag comparison
}
\examples{
# Join and reformat unfiltered demo data and filtered demo data

compare_flags(demo_unfiltered_elev, demo_filtered_elev)
}
