% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wallaby-data.R
\name{wallaby_data}
\alias{wallaby_data}
\title{Wallaby plot data}
\usage{
wallaby_data(
  data,
  subset = "top",
  relation = "one_many",
  time_dependent = FALSE,
  height = 0.6,
  width = 50L,
  total_point = NULL
)
}
\arguments{
\item{data}{The categorized data.}

\item{subset}{A character string specifying the variable used for subsetting
the data. The "top" and "bottom" strings can also be used in this argument.}

\item{relation}{The choice of relationship for the values to display on the
plot, either "one_many" or "many_one."}

\item{time_dependent}{Logical. Should the visualizations be time-dependent?
The default is FALSE.}

\item{height}{The proportion the point takes in the shaded area.}

\item{width}{The number that controls the runif_max to specify how far apart
each point is.}

\item{total_point}{The number of points the users want for the wallaby plot.
The default is NULL, where the number of the point is equal to the original number
of points.}
}
\value{
An object contained the modified data with additional data components.
}
\description{
This function performs data manipulation and path interpolation of the
categorized data. This includes additional data components for labeling and
shading.
}
\details{
The function takes the categorized data and interpolates the path
for each observation. Additionally, the label and shading data are created.
}
\references{
Recreate - Sankey flow chart. (n.d.). Emil Hvitfeldt.
Retrieved April 13, 2023, from
https://www.emilhvitfeldt.com/post/2018-03-20-recreate-sankey-flow-chart/
}
\keyword{internal}
