% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDSR.R
\name{createDSR}
\alias{createDSR}
\alias{getCapacityDSR}
\alias{editDSR}
\title{Create a Demand Side Response (DSR)}
\usage{
createDSR(
  areasAndDSRParam = NULL,
  spinning = 2,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)

getCapacityDSR(area = NULL, opts = antaresRead::simOptions())

editDSR(
  area = NULL,
  unit = NULL,
  nominalCapacity = NULL,
  marginalCost = NULL,
  spinning = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{areasAndDSRParam}{A data.frame with 4 columns \code{area}, \code{unit},
\code{nominalCapacity}, \code{marginalCost} and \code{hour}. 
Hour represent the number of activation hours for the DSR per day.}

\item{spinning}{DSR spinning}

\item{overwrite}{Overwrite the DSR plant if already exist.
This will overwrite the previous area and links.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}

\item{area}{an area where to edit the DSR}

\item{unit}{DSR unit number}

\item{nominalCapacity}{DSR nominalCapacity}

\item{marginalCost}{DSR marginalCost}
}
\value{
\code{createDSR()} and \code{editDSR()}  returns an updated list containing various information about the simulation.

\code{getCapacityDSR()} returns DSR capacity (unit * nominalCapacity of virtual cluster) of the area
}
\description{
Create a Demand Side Response (DSR)
}
\examples{
\dontrun{

library(antaresEditObject)
path<-pathToYourStudy
opts<-setSimulationPath(path, simulation = "input")
area, unit, nominalCapacity and marginalCost
dsrData<-data.frame(area = c("a", "b"), unit = c(10,20), 
                    nominalCapacity = c(100, 120), marginalCost = c(52, 65), hour = c(3, 7))

createDSR(dsrData)

createDSR(dsrData, spinning = 3, overwrite = TRUE)
getAreas()

}
\dontrun{

getCapacityDSR("a")
editDSR("a", unit = 50, nominalCapacity = 8000)
getCapacityDSR("a")

}
\dontrun{

getCapacityDSR("a")
editDSR("a", unit = 50, nominalCapacity = 8000, marginalCost = 45, hour = 9)
getCapacityDSR("a")

}
}
