% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctBalance.R
\name{correctBalance}
\alias{correctBalance}
\title{correctBalance}
\usage{
correctBalance(x)
}
\arguments{
\item{x}{An object of class \code{\link[antaresRead]{readAntares}} (or \code{\link[antaresRead]{simOptions}}) created with 'readAntares()' (or 'setSimulationPath()')}
}
\value{
\code{correctBalance} modifies its input by editing BALANCE and 'ROW BAL.'.
Formulas :
\enumerate{
\item \eqn{BALANCE = BALANCE - 'ROW. BAL.'}
\item \eqn{ROW. BAL = 0}
}
}
\description{
This function corrects the BALANCE with 'ROW BAL.'.
}
\examples{
\dontrun{
# First simulation
studyPath <- "path/to/study/"

setSimulationPath(studyPath, 1)
mydata1 <- readAntares(areas = "all", districts = "all", synthesis = FALSE)
correctBalance(mydata1)

}

}
