% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addloadFactorLink.R
\name{addLoadFactorLink}
\alias{addLoadFactorLink}
\title{Load factors of link}
\usage{
addLoadFactorLink(x)
}
\arguments{
\item{x}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. It must contain the columns
\code{transCapacityDirect} and \code{transCapacityIndirect}.}
}
\value{
\code{addLoadFactorLink} modifies its input by adding to it two columns:

\item{loadFactor}{Proportion of the installed capacity of a link that
is effectively used:

\preformatted{loadFactor = `FLOW LIN` / transCapacity}

Notice that \code{loadFactor} can be positive or negative according to the
direction of the flow.
}
\item{congestion}{1 if the link is saturated (\code{loadFactor = +/-1)},
0 otherwise.
}
For convenience, the function invisibly returns the modified input.
}
\description{
This function computes the load factor of link and add it to an
\code{antaresData} object.
}
\examples{
\dontrun{
# Data required by the function
showAliases("loadFactorLink")

mydata <- readAntares(select = "loadFactorLink")
addLoadFactorLink(mydata)
names(mydata)
}

}
