% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simOptions.R
\name{simOptions}
\alias{simOptions}
\title{Extract simulation options}
\usage{
simOptions(x = NULL)
}
\arguments{
\item{x}{object of class \code{antaresTable} or \code{antaresData}}
}
\value{
list of options used to read the data contained in an object or the last
simulation options read by \code{\link{setSimulationPath}} if \code{x} is
\code{NULL}
}
\description{
The function \code{\link{readAntares}} stores in its output the options used
to read some data (path of the study, area list, link list, start date,
etc.).
}
\details{
\code{simOptions} extracts these options from an object of class 
\code{antaresTable} or \code{antaresOutput}. It can be useful when working on
multiple simulations, either to check how some object has been created or to
use it in some functions like \code{\link{getAreas}} or
\code{\link{getLinks}}

If the parameter of the function is \code{NULL}, it returns the default
simulation options, that is the options set by \code{\link{setSimulationPath}}
the last time it was run.
}
\examples{
\dontrun{
  setSimulationPath(study1)
  
  simOptions() # returns the options for study 1
  
  data <- readAntares()
  
  # Choose a different study
  setSimulationPath(study2)
  
  simOptions() # returns the options for study 2
  
  getAreas() # returns the areas of the secund study
  getAreas(opts = simOptions(data)) # returns the areas of the first study
  
}

}
