% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_exchanges.R, R/stack_exchanges_aliases.R
\name{exchangesStack}
\alias{exchangesStack}
\alias{exchangesStackAliases}
\alias{setExchangesStackAlias}
\title{Plot the exchanges of an area}
\usage{
exchangesStack(
  x,
  stack = "default",
  area = NULL,
  mcYear = "average",
  dateRange = NULL,
  colors = NULL,
  yMin = NULL,
  yMax = NULL,
  customTicks = NULL,
  main = NULL,
  ylab = NULL,
  unit = c("MWh", "GWh", "TWh"),
  compare = NULL,
  compareOpts = list(),
  interactive = getInteractivity(),
  legend = TRUE,
  legendId = sample(1e+09, 1),
  groupId = legendId,
  updateLegendOnMouseOver = TRUE,
  legendItemsPerRow = 5,
  width = NULL,
  height = NULL,
  xyCompare = c("union", "intersect"),
  h5requestFiltering = deprecated(),
  stepPlot = FALSE,
  drawPoints = FALSE,
  timeSteph5 = deprecated(),
  mcYearh5 = deprecated(),
  tablesh5 = deprecated(),
  language = "en",
  hidden = NULL,
  refStudy = NULL,
  ...
)

exchangesStackAliases()

setExchangesStackAlias(
  name,
  variables,
  colors,
  lines = NULL,
  lineColors = NULL,
  lineWidth = 3,
  description = NULL
)
}
\arguments{
\item{x}{Object of class \code{antaresData} created with function
[antaresRead::readAntares]. It is required to contain link data.
If it also contains area data with column `ROW BAL.`, then exchanges with
the rest of the world are also displayed on the chart.}

\item{stack}{Name of the stack to use. If \code{default}, all flows available will be plotted. One can visualize available stacks with 
\code{exchangesStackAliases}}

\item{area}{Name of a single area. The flows from/to this area will be drawn by the
function.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{colors}{Vector of colors with same length as parameter \code{variables}. If 
\code{variables} is an alias, then this argument should be \code{NULL} in 
order to use default colors.}

\item{yMin}{\code{numeric}, the minimum value to be displayed on all y Axis. If \code{NULL}, the min value is automatically set}

\item{yMax}{\code{numeric}, the maximum value to be displayed on all y Axis. If \code{NULL}, the max value is automatically set}

\item{customTicks}{\code{numeric} vector of the custom ticks values to be displayed on the y Axis. If \code{NULL}, the ticks are automatically generated}

\item{main}{Title of the graph.}

\item{ylab}{Title of the Y-axis.}

\item{unit}{Unit used in the graph. Possible values are "MWh", "GWh" or "TWh".}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart. See details
 if you are drawing a map.}

\item{compareOpts}{List of options that indicates the number of charts to create and their 
position. Check out the documentation of 
[manipulateWidget::compareOptions] to see available options.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{legend}{Logical value indicating if a legend should be drawn. This argument is 
usefull when one wants to create a shared legend with
[prodStackLegend()]}

\item{legendId}{Id of the legend linked to the graph. This argument is 
usefull when one wants to create a shared legend with 
[prodStackLegend()]}

\item{groupId}{Parameter that can be used to synchronize the horizontal 
zoom of multiple charts. All charts that need to be synchronized must
have the same group.}

\item{updateLegendOnMouseOver}{\code{LogicalValue}. If \code{TRUE} the legend will be updated when the mouse is over a stack. If \code{FALSE} the legend will be updated on a click}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{xyCompare}{Use when you compare studies, can be "union" or "intersect". If union, all
of mcYears in one of studies will be selectable. If intersect, only mcYears in all
studies will be selectable.}

\item{h5requestFiltering}{Contains arguments used by default for h5 request,
typically h5requestFiltering = list(links = getLinks(areas = myArea), mcYears = myMcYear)}

\item{stepPlot}{\code{boolean}, step style for curves.}

\item{drawPoints}{\code{boolean}, add points on graph}

\item{timeSteph5}{\code{character} timeStep to read in h5 file. Only for Non interactive mode.}

\item{mcYearh5}{\code{numeric} mcYear to read for h5. Only for Non interactive mode.}

\item{tablesh5}{\code{character} tables for h5 ("areas" "links", "clusters" or "disticts"). Only for Non interactive mode.}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{hidden}{\code{logical} Names of input to hide. Defaut to NULL}

\item{refStudy}{An object of class \code{antaresData} created with function 
[antaresRead::readAntares()] containing data for areas and or
districts. Can also contains an opts who refer to a h5 file.}

\item{...}{Other arguments for [manipulateWidget::manipulateWidget]}

\item{name}{name of the stack to create or update}

\item{variables}{A named list of expressions created with [base::alist]. The
name of each element is the name of the variable to draw in the stacked
graph. The element itself is an expression explaining how to compute the
variable (see examples).}

\item{lines}{A named list of expressions created with [base::alist]
indicating how to compute the curves to display on top of the stacked graph.
It should be \code{NULL} if there is no curve to trace or if parameter
\code{variables} is an alias.}

\item{lineColors}{Vector of colors with same length as parameter \code{lines}. This argument
should be \code{NULL} if there is no curve to trace or if parameter
\code{variables} is an alias.}

\item{lineWidth}{Optionnal. Defaut to 3. Vector of width with same length as parameter \code{lines} (or only one value).}

\item{description}{Description of the stack. It is displayed by function 
\code{exchangesStackAliases}.}
}
\value{
A htmlwidget of class \code{dygraph}. It can be modified with functions from
package \code{dygraphs}.
}
\description{
This function draws a stack representing the evolution of the exchanges of
an area with its neighbours. Positive values denotes exports and negative
values imports.
User can either plot all flows from/to an area using the \code{default} stack or use a custom one.
User can see available stacks with \code{exchangesStackAliases} and create new ones
with \code{setExchangesStackAlias}.
}
\details{
Compare argument can take following values :
\itemize{
   \item "mcYear"
   \item "main"
   \item "unit"
   \item "area"
   \item "legend"
   \item "stepPlot"
   \item "drawPoints"
   }
}
\examples{
\dontrun{
mydata <- readAntares(links = "all", timeStep = "daily")
exchangesStack(mydata)

# Also display exchanges with the rest of the world
mydata <- readAntares(areas = "all", links = "all", timeStep = "daily")
exchangesStack(mydata)

# Use compare :
exchangesStack(mydata, compare = "mcYear")
exchangesStack(mydata, compare = "area")
exchangesStack(mydata, compare = "unit")
exchangesStack(mydata, compare = "legend")
# Compare studies with refStudy argument
exchangesStack(x = myData1, refStudy = myData2)
exchangesStack(x = myData1, refStudy = myData2, interactive = FALSE)
exchangesStack(x = list(myData2, myData3, myData4), refStudy = myData1)
exchangesStack(x = list(myData2, myData3, myData4), refStudy = myData1, interactive = FALSE)

# Use h5 opts
# Set path of simulaiton
setSimulationPath(path = path1)

# Convert your study in h5 format
writeAntaresH5(path = mynewpath)

# Redefine sim path with h5 file
opts <- setSimulationPath(path = mynewpath)
exchangesStack(x = opts)

# Compare elements in a single study
exchangesStack(x = opts, .compare = "mcYear")

# Compare 2 studies
exchangesStack(x = list(opts, opts2))

# Compare 2 studies with argument refStudy
exchangesStack(x = opts, refStudy = opts2)
exchangesStack(x = opts, refStudy = opts2, interactive = FALSE, mcYearh5 = 2, areas = myArea)
exchangesStack(x = opts, refStudy = opts2, h5requestFiltering = list(
areas = getAreas(select = "a"),
links = getLinks(areas = myArea),
mcYears = myMcYear))

}

}
