% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assertDate}
\alias{assertDate}
\alias{assertTime}
\title{Convert to Date (or POSIXct) and assert successful conversion}
\usage{
assertDate(x)

assertTime(x)
}
\arguments{
\item{x}{An input object suitable for \code{anydate} or \code{anytime}}
}
\value{
A vector of \code{Date} or \code{POSIXct} objects. As a side
effect, an error will be thrown in any of the input was not convertible.
}
\description{
Converts its input to type \code{Date} (or \code{POSIXct}), and asserts
that the content is in fact of suitable type by checking for remaining
\code{NA}
}
\details{
Note that these functions \emph{just check for \code{NA}} and cannot
check for semantic correctness.
}
\examples{
assertDate(c("2001/02/03", "2001-02-03", "20010203"))
assertTime(c("2001/02/03 04:05:06", "2001-02-03  04:05:06", "20010203 040506"))
}
\author{
Dirk Eddelbuettel
}
