# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

anytime_cpp <- function(x, tz = "UTC", asUTC = FALSE, asDate = FALSE, useR = FALSE, oldHeuristic = FALSE) {
    .Call(`_anytime_anytime_cpp`, x, tz, asUTC, asDate, useR, oldHeuristic)
}

#' The time and date parsing and conversion relies on trying a (given
#' and fixed) number of timeformats. The format used is the one employed
#' by the underlying implementation of the Boost date_time library.
#'
#' @title Functions to retrieve, set or remove formats used for parsing dates.
#' @param fmt A vector of character values in the form understood by Boost
#' date_time
#' @return Nothing in the case of \code{addFormats}; a character vector of
#' formats in the case of \code{getFormats}
#' @seealso \code{\link{anytime-package}} and references therein
#' @author Dirk Eddelbuettel
#' @examples
#'   getFormats()
#'   addFormats(c("%d %b %y",      # two-digit date [not recommended], textual month
#'                "%a %b %d %Y"))  # weekday weeknumber four-digit year
#'   removeFormats("%d %b %y")     # remove first
getFormats <- function() {
    .Call(`_anytime_getFormats`)
}

#' @rdname getFormats
addFormats <- function(fmt) {
    invisible(.Call(`_anytime_addFormats`, fmt))
}

#' @rdname getFormats
removeFormats <- function(fmt) {
    invisible(.Call(`_anytime_removeFormats`, fmt))
}

testFormat_impl <- function(fmt, s, tz = "") {
    .Call(`_anytime_testFormat_impl`, fmt, s, tz)
}

testOutput_impl <- function(fmt, s) {
    .Call(`_anytime_testOutput_impl`, fmt, s)
}

setDebug <- function(mode) {
    .Call(`_anytime_setDebug`, mode)
}

format <- function(x) {
    .Call(`_anytime_format`, x)
}

setMaxIntAsYYYYMMDD <- function(val) {
    invisible(.Call(`_anytime_setMaxIntAsYYYYMMDD`, val))
}

setMaxIntAsDate <- function(val) {
    invisible(.Call(`_anytime_setMaxIntAsDate`, val))
}

setInitialTZ <- function(tz) {
    invisible(.Call(`_anytime_setInitialTZ`, tz))
}

