% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{sedona_render_choropleth_map}
\alias{sedona_render_choropleth_map}
\title{Visualize a Sedona spatial RDD using a choropleth map.}
\usage{
sedona_render_choropleth_map(
  pair_rdd,
  resolution_x,
  resolution_y,
  output_location,
  output_format = c("png", "gif", "svg"),
  boundary = NULL,
  color_of_variation = c("red", "green", "blue"),
  base_color = c(0, 0, 0),
  shade = TRUE,
  reverse_coords = FALSE,
  overlay = NULL,
  browse = interactive()
)
}
\arguments{
\item{pair_rdd}{A pair RDD with Sedona Polygon objects being keys and
java.lang.Long being values.}

\item{resolution_x}{Resolution on the x-axis.}

\item{resolution_y}{Resolution on the y-axis.}

\item{output_location}{Location of the output image. This should be the
desired path of the image file excluding extension in its file name.}

\item{output_format}{File format of the output image. Currently "png",
"gif", and "svg" formats are supported (default: "png").}

\item{boundary}{Only render data within the given rectangular boundary.
The \code{boundary} parameter can be set to either a numeric vector of
c(min_x, max_y, min_y, max_y) values, or with a bounding box object
e.g., new_bounding_box(sc, min_x, max_y, min_y, max_y), or NULL
(the default). If \code{boundary} is NULL, then the minimum bounding box of the
input spatial RDD will be computed and used as boundary for rendering.}

\item{color_of_variation}{Which color channel will vary depending on values
of data points. Must be one of "red", "green", or "blue". Default: red.}

\item{base_color}{Color of any data point with value 0. Must be a numeric
vector of length 3 specifying values for red, green, and blue channels.
Default: c(0, 0, 0).}

\item{shade}{Whether data point with larger magnitude will be displayed with
darker color. Default: TRUE.}

\item{reverse_coords}{Whether to reverse spatial coordinates in the plot
(default: FALSE).}

\item{overlay}{A \code{viz_op} object containing a raster image to be
displayed on top of the resulting image.}

\item{browse}{Whether to open the rendered image in a browser (default:
interactive()).}
}
\value{
No return value.
}
\description{
Generate a choropleth map of a pair RDD assigning integral values to
polygons.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  pt_input_location <- "/dev/null" # replace it with the path to your input file
  pt_rdd <- sedona_read_dsv_to_typed_rdd(
    sc,
    location = pt_input_location,
    type = "point",
    first_spatial_col_index = 1
  )
  polygon_input_location <- "/dev/null" # replace it with the path to your input file
  polygon_rdd <- sedona_read_geojson_to_typed_rdd(
    sc,
    location = polygon_input_location,
    type = "polygon"
  )
  join_result_rdd <- sedona_spatial_join_count_by_key(
    pt_rdd,
    polygon_rdd,
    join_type = "intersect",
    partitioner = "quadtree"
  )
  sedona_render_choropleth_map(
    join_result_rdd,
    400,
    200,
    output_location = tempfile("choropleth-map-"),
    boundary = c(-86.8, -86.6, 33.4, 33.6),
    base_color = c(255, 255, 255)
  )
}

}
\seealso{
Other Sedona visualization routines: 
\code{\link{sedona_render_heatmap}()},
\code{\link{sedona_render_scatter_plot}()}
}
\concept{Sedona visualization routines}
