% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/handling.R
\name{concatenate}
\alias{concatenate}
\title{Concatenate genes into a single matrix}
\usage{
concatenate(x, genes = TRUE)
}
\arguments{
\item{x}{a \linkS4class{multidna} object.}

\item{genes}{an optional vector indicating the genes to retain for the concatenation; any way to subset the list in x@dna is acceptable; by default, all genes are used.}
}
\description{
This function concatenates separate DNA alignments into a single DNAbin matrix.
}
\examples{
## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
plot(x)

image(concatenate(x))
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}

