% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{add-shade}
\alias{add-shade}
\alias{add_shade}
\alias{add_shade_weekend}
\title{Add a shaded area to a chart}
\usage{
add_shade(ax, from, to, color = "#848484", opacity = 0.2, label = NULL, ...)

add_shade_weekend(ax, color = "#848484", opacity = 0.2, label = NULL, ...)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{from}{Vector of position to start shadow.}

\item{to}{Vector of position to end shadow.}

\item{color}{Color of the shadow.}

\item{opacity}{Opacity of the shadow.}

\item{label}{Add a label to the shade, use a \code{character}
or see \code{\link{label}} for more controls.}

\item{...}{Additional arguments, see
\url{https://apexcharts.com/docs/options/annotations/} for possible options.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
\code{add_shade()} allow to add a shaded area on specified range,
\code{add_shade_weekend()} add a shadow on every week-end.
}
\note{
\code{add_shade_weekend} only works if variable
used for x-axis is of class \code{Date} or \code{POSIXt}.
}
\examples{

library(apexcharter)
data("consumption")

# specify from and to date
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(from = "2020-01-06", to = "2020-01-20")

# you can add several shadows
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(from = "2020-01-06", to = "2020-01-20") \%>\% 
  add_shade(from = "2020-02-04", to = "2020-02-10")

# or use a vector
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(
    from = c("2020-01-06", "2020-02-04"),
    to = c("2020-01-20", "2020-02-10")
  )


# Add a label
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(
    from = "2020-01-06", to = "2020-01-20",
    label = "interesting period"
  )

# add label with more options
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(
    from = "2020-01-06", to = "2020-01-20",
    color = "firebrick",
    label = label(
      text = "something happened",
      background = "firebrick",
      color = "white", 
      fontWeight = "bold",
      padding = c(3, 5, 3, 5)
    )
  )


# automatically add shadow on week-ends
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade_weekend()



}
