% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex.R
\name{apex}
\alias{apex}
\title{Quick ApexCharts}
\usage{
apex(
  data,
  mapping,
  type = "column",
  ...,
  auto_update = TRUE,
  synchronize = NULL,
  serie_name = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{mapping}{Default list of aesthetic mappings to use for chart}

\item{type}{Specify the chart type. Available options:
\code{"column"}, \code{"bar"},
\code{"line"}, \code{"step"}, \code{"spline"},
\code{"area"}, \code{"area-step"}, \code{"area-spline"},
\code{"pie"}, \code{"donut"},
\code{"radialBar"}, \code{"radar"}, \code{"scatter"},
\code{"heatmap"}, \code{"treemap"},
\code{"timeline"}, \code{"dumbbell"} and \code{"slope"}.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{auto_update}{In Shiny application, update existing chart
rather than generating new one. Can be \code{TRUE}/\code{FALSE} or
use \code{\link[=config_update]{config_update()}} for more control.}

\item{synchronize}{Give a common id to charts to synchronize them (tooltip and zoom).}

\item{serie_name}{Name for the serie displayed in tooltip,
only used for single serie.}

\item{width, height}{A numeric input in pixels.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Initialize a chart with three main parameters :
data, mapping and type of chart.
}
\examples{
library(ggplot2)
library(apexcharter)

# make a barchart with a frequency table
data("mpg", package = "ggplot2")
apex(mpg, aes(manufacturer), type = "bar")


# timeseries
data("economics", package = "ggplot2")
apex(
  data = economics, 
  mapping = aes(x = date, y = uempmed), 
  type = "line"
)

# you can add option to apex result :
apex(
  data = economics, 
  mapping = aes(x = date, y = uempmed), 
  type = "line"
) \%>\% 
  ax_stroke(width = 1)


# with group variable
data("economics_long", package = "ggplot2")
apex(
  data = economics_long, 
  mapping = aes(x = date, y = value01, group = variable), 
  type = "line"
)
}
