% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_ol.R
\name{apollo_ol}
\alias{apollo_ol}
\title{Calculates the probability of an ordered logit model}
\usage{
apollo_ol(ol_settings, functionality)
}
\arguments{
\item{ol_settings}{List of settings for the OL model. It should include the following.
\describe{
  \item{outcomeOrdered}{Numeric vector. Dependant variable. The coding of this variable is assumed to be from 1 to the maximum number of different levels. For example, if the ordered response has three possible values: "never", "sometimes" and "always", then it is assumed that outcomeOrdered contains "1" for "never", "2" for "sometimes", and 3 for "always". If another coding is used, then it should be specified using the \code{coding} argument.}
  \item{V}{Numeric vector. A single explanatory variable (usually a latent variable). Must have the same number of rows as outcomeOrdered.}
  \item{tau}{Numeric vector. Thresholds. As many as number of different levels in the dependent variable - 1. Extreme thresholds are fixed at -inf and +inf. No mixing allowed in thresholds.}
  \item{coding}{Numeric or character vector. Optional argument. Defines the order of the levels in \code{outcomeOrdered}. The first value is associated with the lowest level of \code{V}, and the last one with the highest value. If not provided, is assumed to be \code{1:(length(tau) + 1)}.}
  \item{rows}{Boolean vector. TRUE if a row must be considered in the calculations, FALSE if it must be excluded. It must have length equal to the length of argument \code{choiceVar}. Default value is \code{"all"}, meaning all rows are considered in the calculation.}
}}

\item{functionality}{Character. Can take different values depending on desired output.
\describe{
  \item{"estimate"}{Used for model estimation.}
  \item{"prediction"}{Used for model predictions.}
  \item{"validate"}{Used for validating input.}
  \item{"zero_LL"}{Used for calculating null likelihood.}
  \item{"conditionals"}{Used for calculating conditionals.}
  \item{"output"}{Used for preparing output after model estimation.}
  \item{"raw"}{Used for debugging.}
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \describe{
          \item{"estimate"}{vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.}
          \item{"prediction"}{List. Returns a list with the probabilities for each possible outcome.}
          \item{"validate"}{Boolean. Returns TRUE if all tests are passed.}
          \item{"zero_LL"}{vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.}
          \item{"conditionals"}{Same as "prediction".}
          \item{"output"}{Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).}
          \item{"raw"}{Same as "prediction".}
        }
}
\description{
Calculates the probabilities of an ordered logit model and can also perform other operations based on the value of the \code{functionality} argument.
}
\details{
This function estimates an ordered logit model of the type:
y* = V + epsilon
outcomeOrdered =  1 if   -Inf < y* < tau[1]
     2 if tau[1] < y* < tau[2]
     ...
     maxLvl if tau[length(tau)] < y* < +Inf
Where epsilon is distributed standard logistic, and the values 1, 2, ..., maxLvl can be
replaces by coding[1], coding[2], ..., coding[maxLvl].
The behaviour of the function changes depending on the value of the \code{functionality} argument.
}
