% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_mdcev.R
\name{apollo_mdcev}
\alias{apollo_mdcev}
\title{Calculates MDCEV likelihoods.}
\usage{
apollo_mdcev(mdcev_settings, functionality)
}
\arguments{
\item{mdcev_settings}{List of settings for the MDCEV model. It must include the following.
\itemize{
  \item \strong{\code{V}}: Named list. Utilities of the alternatives. Names of elements must match those in argument 'alternatives'.
  \item \strong{\code{alternatives}}: Character vector. Names of alternatives, elements must match the names in list 'V'.
  \item \strong{\code{alpha}}: Named list. Alpha parameters for each alternative, including for any outside good. As many elements as alternatives.
  \item \strong{\code{gamma}}: Named list. Gamma parameters for each alternative, excluding any outside good. As many elements as inside good alternatives.
  \item \strong{\code{sigma}}: Numeric scalar. Scale parameter of the model extreme value type I error.
  \item \strong{\code{cost}}: Named list of numeric vectors. Price of each alternative. One element per alternative, each one as long as the number of observations or a scalar. Names must match those in \code{alternatives}.
  \item \strong{\code{avail}}: Named list. Availabilities of alternatives, one element per alternative. Names of elements must match those in argument 'alternatives'. Value for each element can be 1 (scalar if always available) or a vector with values 0 or 1 for each observation.
  \item \strong{\code{continuousChoice}}: Named list of numeric vectors. Amount of consumption of each alternative. One element per alternative, as long as the number of observations or a scalar. Names must match those in \code{alternatives}.
  \item \strong{\code{budget}}: Numeric vector. Budget for each observation.
  \item \strong{\code{minConsumption}}: Named list of scalars or numeric vectors. Minimum consumption of the alternatives, if consumed. As many elements as alternatives. Names must match those in \code{alternatives}.
  \item \strong{\code{outside}}: Character. Optional name of the outside good.
  \item \strong{\code{rows}}: Logical vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
  \item \strong{\code{componentName}}: Character. Name given to model component.
  \item \strong{\code{nRep}}: Numeric scalar. Number of simulations of the whole dataset used for forecasting. The forecast is the average of these simulations. Default is 100.
  \item \strong{\code{rawPrediction}}: Logical scalar. TRUE for prediction to be returned at the draw level (a 3-dim array). FALSE for prediction to be returned averaged across draws. Default is FALSE.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item \code{"estimate"} Used for model estimation.
  \item \code{"prediction"} Used for model predictions.
  \item \code{"validate"} Used for validating input.
  \item \code{"zero_LL"} Used for calculating null likelihood.
  \item \code{"conditionals"} Used for calculating conditionals.
  \item \code{"output"} Used for preparing output after model estimation.
  \item \code{"raw"} Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the observed consumption for each observation.
          \item \strong{\code{"prediction"}}: A matrix with one row per observation, and columns indicating means and s.d. of continuous and discrete predicted consumptions.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: Not implemented. Returns a vector of NA with as many elements as observations.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"estimate"}
        }
}
\description{
Calculates the likelihood of a Multiple Discrete Continuous Extreme Value (MDCEV) model.
}
