% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_op.R
\name{apollo_op}
\alias{apollo_op}
\title{Calculates the probability of an ordered probit model}
\usage{
apollo_op(op_settings, functionality)
}
\arguments{
\item{op_settings}{List of settings for the OP model. It should include the following.
\itemize{
  \item \code{outcomeOrdered} Numeric vector. Dependant variable. The coding of this variable is assumed to be from 1 to the maximum number of different levels. For example, if the ordered response has three possible values: "never", "sometimes" and "always", then it is assumed that outcomeOrdered contains "1" for "never", "2" for "sometimes", and 3 for "always". If another coding is used, then it should be specified using the \code{coding} argument.
  \item \code{V} Numeric vector/matrix/3-sim array. A single explanatory variable (usually a latent variable). Must have the same number of rows as outcomeOrdered.
  \item \code{tau} List of numeric vectors/matrices/3-dim arrays. Thresholds. As many as number of different levels in the dependent variable - 1. Extreme thresholds are fixed at -inf and +inf. Mixing is allowed in thresholds. Can also be a matrix with as many rows as observations and as many columns as thresholds.
  \item \code{coding} Numeric or character vector. Optional argument. Defines the order of the levels in \code{outcomeOrdered}. The first value is associated with the lowest level of \code{outcomeOrdered}, and the last one with the highest value. If not provided, is assumed to be \code{1:(length(tau) + 1)}.
  \item \code{rows} Boolean vector. TRUE if a row must be considered in the calculations, FALSE if it must be excluded. It must have length equal to the length of argument \code{outcomeOrdered}. Default value is \code{"all"}, meaning all rows are considered in the calculation.
  \item \code{componentName} Character. Name given to model component.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item \strong{"estimate"} Used for model estimation.
  \item \strong{"prediction"} Used for model predictions.
  \item \strong{"validate"} Used for validating input.
  \item \strong{"zero_LL"} Used for calculating null likelihood.n Not implemented for ordered probit.
  \item \code{"shares_LL"}: Used for calculating likelihood with constants only.
  \item \strong{"conditionals"} Used for calculating conditionals.
  \item \strong{"output"} Used for preparing output after model estimation.
  \item \strong{"raw"} Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \strong{\code{"estimate"}}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \strong{\code{"prediction"}}: List of vectors/matrices/arrays. Returns a list with the probabilities for all possible levels, with an extra element for the probability of the chosen alternative.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}, but it also runs a set of tests to validate the function inputs.
          \item \strong{\code{"zero_LL"}}: Not implemented. Returns a vector of NA with as many elements as observations.
          \item \strong{\code{"shares_LL"}}: Not implemented. Returns a vector of NA with as many elements as observations.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}
          \item \strong{\code{"output"}}: Same as \code{"estimate"} but also writes summary of input data to internal Apollo log.
          \item \strong{\code{"raw"}}: Same as \code{"prediction"}
        }
}
\description{
Calculates the probabilities of an ordered probit model and can also perform other operations based on the value of the \code{functionality} argument.
}
\details{
This function estimates an ordered probit model of the type:
\deqn{ y^{*} = V + \epsilon \\
y = 1 if -\infty < y^{*} < \tau_1,
    2 if \tau_1 < y^{*} < \tau_2,
    ...,
    max(y) if \tau_{max(y)-1} < y^{*} < \infty}
Where \eqn{\epsilon} is distributed standard normal, and the values 1, 2, ..., \eqn{max(y)} can be
replaced by \code{coding[1], coding[2], ..., coding[maxLvl]}.
The behaviour of the function changes depending on the value of the \code{functionality} argument.
}
