% Generated by roxygen2 (4.0.0): do not edit by hand
\name{aprof}
\alias{aprof}
\title{Create an 'aprof' objects for usage in the package 'aprof'}
\usage{
aprof(src = NULL, output = NULL, memoutput = NULL)
}
\arguments{
\item{src}{The name of the source code file (and path if not in the working
directory). The source code file is expected to be a
a plain text file (e.g. txt, .R), containing the code of the
previously profiled program. If left empty, some "aprof" functions
(e.g. \code{readLineDensity}) will attempt to extract this information from
the call stack but this is not recommended (as the success of
file name detection operations vary). Note that
functions that require a defined source file will fail if
the source file is not defined or detected in the call stack.}

\item{output}{The file name (and path if not in the working
directory) of a previously created profiling exercise.}

\item{memoutput}{Optional, the file name (and path)
of the memory profile from a previous profiling exercise
[NOTE: not available in this version].}
}
\value{
An aprof object
}
\description{
Create 'aprof' objects for usage with 'aprof' functions
}
\details{
Creates an "aprof" object from the R-profiler's output and a source file.
The objects created through "aprof" can be used by the standard functions
plot, summary and print (more specifically:
\code{plot.aprof}, \code{summary.aprof} and \code{print.aprof}).
See the exampe below for more details.
}
\examples{
\dontrun{
   # create function to profile
     foo <- function(N){
             preallocate<-numeric(N)
             grow<-NULL
              for(i in 1:N){
                  preallocate[i]<-N/(i+1)
                  grow<-c(grow,N/(i+1))
                 }
     }

     #save function to a source file and reload
     dump("foo",file="foo.R")
     source("foo.R")

     # create file to save profiler output
     tmp<-tempfile()

     # Profile the function
     Rprof(tmp,line.profiling=TRUE)
     foo(1e4)
     Rprof(append=FALSE)

     # Create a aprof object
     fooaprof<-aprof("foo.R",tmp)
     #display basic information, summarize and plot the object
     fooaprof
     summary(fooaprof)
     plot(fooaprof)
     profileplot(fooaprof)
	}
}
\author{
Marco D. Visser
}
\seealso{
\code{\link{plot.aprof}}, \code{\link{summary.aprof}},
\code{\link{print.aprof}}, \code{\link{Rprof}} and
\code{\link{summaryRprof}}.
}
\concept{
Line profiling
}

