% Generated by roxygen2 (4.0.1): do not edit by hand
\name{apsim}
\alias{apsim}
\title{Run APSIM simulations from R}
\usage{
apsim(exe, wd = getwd(), files = NULL)
}
\arguments{
\item{exe}{path to the APSIM executable}

\item{wd}{working directory containing the .apsim files to be run}

\item{files}{.apsim files to be run; if left empty all .apsim files in \code{wd} will be run}
}
\value{
list of output files; each element corresponds to an .apsim file
}
\description{
This function will run APSIM from R.  The only required input is the
file path to the APSIM executable.  It is assumed the current working directory contains the .apsim file(s)
to be run.  If that is not the case then the directory containing the .apsim file(s) to be run
can to be specified by \code{wd}.  One can specify a list of .apsim files to be run within the
directory \code{wd} using the \code{files} argument, otherwise all .apsim files within \code{wd} are run.
The results for each .apsim file that is run is an element of the list that is returned.
Each element of the list is of the class \code{"apsim"}.
}
\examples{
\dontrun{
exe <-"C:/Program Files (x86)/Apsim76-r3376/Model/Apsim.exe"
wd <- "~/APSIM"
to_run <- c("Centro.apsim", "Continuous Wheat.apsim")
results <- apsim(exe, wd, files = to_run)
}
}

