% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsim.R
\name{edit_apsim}
\alias{edit_apsim}
\title{Edit an APSIM (Classic) Simulation}
\usage{
edit_apsim(
  file,
  src.dir = ".",
  wrt.dir = NULL,
  node = c("Clock", "Weather", "Soil", "SurfaceOrganicMatter", "MicroClimate", "Crop",
    "Manager", "Outputfile", "Other"),
  soil.child = c("Metadata", "Water", "Physical", "OrganicMatter", "Chemical",
    "Analysis", "InitialWater", "Sample", "SWIM"),
  manager.child = NULL,
  parm = NULL,
  value = NULL,
  overwrite = FALSE,
  edit.tag = "-edited",
  parm.path = NULL,
  root,
  verbose = TRUE,
  check.length = TRUE
)
}
\arguments{
\item{file}{file ending in .apsim to be edited}

\item{src.dir}{directory containing the .apsim file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{node}{either \sQuote{Clock}, \sQuote{Weather}, \sQuote{Soil}, 
\sQuote{SurfaceOrganicMatter}, \sQuote{MicroClimate}, \sQuote{Crop}, \sQuote{Manager}, \sQuote{Outputfile} or \sQuote{Other}}

\item{soil.child}{specific soil component to be edited}

\item{manager.child}{specific manager component to be edited (not implemented yet)}

\item{parm}{parameter to be edited}

\item{value}{new values for the parameter to be edited}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{parm.path}{path to the attribute to edit when node is \sQuote{Other}}

\item{root}{supply the node postion in the case of multiple simulations such as factorials.}

\item{verbose}{whether to print information about successful edit}

\item{check.length}{check whether vectors are of the correct length}
}
\value{
(when verbose=TRUE) complete file path to edited .apsimx file is returned as a character string.
As a side effect this function creates a new (XML) .apsimx file.
}
\description{
This function allows editing of an APSIM (Classic) simulation file.
}
\details{
The variables specified by \code{parm} within the .apsim file specified by \code{file} 
in the source directory \code{src.dir} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the length of the vector \code{parm}.  The current
.apsim file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\sQuote{file} \emph{-edited.apsim} will be created.  If (verbose = TRUE) then the name
 of the written file is returned. 
 
 When node equals Outputfile, the editing allows to add variables, but not to remove them at the moment.
}
\note{
The components that can be edited are restricted becuase this is better in preventing
errors of editing unintended parts of the file. The disadvantage is that there is less flexibility
compared to the similar function in the 'apsimr' package.
}
\examples{
\donttest{
## This example will read one of the examples distributed with APSIM
## but write to a temporary directory

tmp.dir <- tempdir()

extd.dir <- system.file("extdata", package = "apsimx")
edit_apsim("Millet", src.dir = extd.dir, wrt.dir = tmp.dir, 
           node = "Clock",
           parm = "start_date", value = "01/02/1940")

## Editing all of the KL values for Millet
pp.KL <- inspect_apsim_xml("Millet.apsim", src.dir = extd.dir, 
                  parm = "SoilCrop[8]/KL")
                 
kls <- seq(0.08, 0.2, length.out = 11)

edit_apsim("Millet.apsim", 
           src.dir = extd.dir,
           wrt.dir = tmp.dir,
           node = "Other", 
           parm.path = pp.KL,
           value = kls)
           
## Check that it was properly edited

inspect_apsim("Millet-edited.apsim", 
              src.dir = tmp.dir,
              node = "Soil",
              soil.child = "Water",
              parm = "KL")

              
}

}
