% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_worldmodeler_soil_profile.R
\name{get_worldmodeler_soil_profile}
\alias{get_worldmodeler_soil_profile}
\title{Generate a synthetic APSIM soil profile from the World Modeler database}
\usage{
get_worldmodeler_soil_profile(
  lonlat,
  fix = FALSE,
  check = FALSE,
  soil.name,
  verbose = FALSE,
  cleanup = FALSE
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(-93, 42)) or matrix.}

\item{fix}{whether to attempt to fix issues with the profile}

\item{check}{whether to check the soil profile}

\item{soil.name}{optional soil name}

\item{verbose}{default is FALSE}

\item{cleanup}{whether to delete temporary files}
}
\value{
it generates an object of class \sQuote{soil_profile}.
}
\description{
Retrieves soil data from the World Modeler global database and converts it to an apsimx soil_profile object
}
\examples{
\dontrun{
## Get soil profile properties for a single point
## This causes a fatal error at the moment
## This is why I don't run it
if(FALSE){
  sp1 <- get_worldmodeler_soil_profile(lonlat = c(-93, 42), fix = TRUE, verbose = FALSE)

  ## Visualize
  plot(sp1)
  plot(sp1, property = "water")
}
}
}
\author{
Brian Collins (University of Southern Queensland) and Fernando Miguez
}
