% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-geocoders.R
\name{list_geocoders}
\alias{list_geocoders}
\alias{default_geocoder}
\title{List Available Geocoder Services}
\usage{
list_geocoders(token = arc_token())

default_geocoder(token = arc_token())
}
\arguments{
\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}
}
\value{
a \code{data.frame} with columns \code{url}, \code{northLat}, \code{southLat},
\code{eastLon}, \code{westLon}, \code{name}, \code{suggest}, \code{zoomScale}, \code{placefinding}, \code{batch}.
}
\description{
Evaluates the logged in user from an authorization token and returns
a data.frame containing the available geocoding services for the
associated token.

For users who have not signed into a private portal or ArcGIS Online,
the public \href{https://www.esri.com/en-us/arcgis/products/arcgis-world-geocoder}{ArcGIS World Geocoder} is used. Otherwise, the first available geocoding service associated
with your authorization token is used.
}
\details{
The \code{default_geocoder()} will return the ArcGIS World Geocoder if no
token is available. \code{list_geocoder()} requires an authorization
token.

To manually create a \code{GeocodeServer} object, see \code{\link[=geocode_server]{geocode_server()}}.
}
\examples{

# Default geocoder object
# ArcGIS World Geocoder b/c no token
default_geocoder()

# Requires an Authorization Token
\dontrun{
list_geocoders()
}
}
