% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-find-candidates.R
\name{find_address_candidates}
\alias{find_address_candidates}
\title{Find Address Candidates}
\usage{
find_address_candidates(
  single_line = NULL,
  address = NULL,
  address2 = NULL,
  address3 = NULL,
  neighborhood = NULL,
  city = NULL,
  subregion = NULL,
  region = NULL,
  postal = NULL,
  postal_ext = NULL,
  country_code = NULL,
  search_extent = NULL,
  location = NULL,
  category = NULL,
  crs = NULL,
  max_locations = NULL,
  for_storage = FALSE,
  match_out_of_range = NULL,
  location_type = NULL,
  lang_code = NULL,
  source_country = NULL,
  preferred_label_values = NULL,
  magic_key = NULL,
  geocoder = default_geocoder(),
  token = arc_token(),
  .progress = TRUE
)
}
\arguments{
\item{single_line}{a character vector of addresses to geocode. If provided
other \code{address} fields cannot be used. If \code{address} is not provided,
\code{single_line} must be.}

\item{address}{a character vector of the first part of a street address.
Typically used for the street name and house number. But can also be a place
or building name. If \code{single_line} is not provided, \code{address} must be.}

\item{address2}{a character vector of the second part of a street address.
Typically includes a house number, sub-unit, street, building, or place name.
Optional.}

\item{address3}{a character vector of the third part of an address. Optional.}

\item{neighborhood}{a character vector of the smallest administrative division
associated with an address. Typically, a neighborhood or a section of a
larger populated place. Optional.}

\item{city}{a character vector of the next largest administrative division
associated with an address, typically, a city or municipality. A city is a
subdivision of a subregion or a region. Optional.}

\item{subregion}{a character vector of the next largest administrative division
associated with an address. Depending on the country, a subregion can
represent a county, state, or province. Optional.}

\item{region}{a character vector of the largest administrative division
associated with an address, typically, a state or province. Optional.}

\item{postal}{a character vector of the standard postal code for an address,
typically, a three– to six-digit alphanumeric code. Optional.}

\item{postal_ext}{a character vector of the postal code extension, such as
the United States Postal Service ZIP+4 code, provides finer resolution or
higher accuracy when also passing postal. Optional.}

\item{country_code}{default \code{NULL.} An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{search_extent}{an object of class \code{bbox} that limits the search area. This is especially useful for applications in which a user will search for places and addresses within the current map extent. Optional.}

\item{location}{an \code{sfc_POINT} object that centers the search. Optional.}

\item{category}{a scalar character. Place or address type that can be used to
filter suggest results. Optional.}

\item{crs}{the CRS of the returned geometries. Passed to \code{sf::st_crs()}.
Ignored if \code{locations} is not an \code{sfc_POINT} object.}

\item{max_locations}{the maximum number of results to return. The default is
15 with a maximum of 50. Optional.}

\item{for_storage}{default \code{FALSE}. Whether or not the results will be saved
for long term storage.}

\item{match_out_of_range}{set to \code{TRUE} by service by default. Matches locations Optional.}

\item{location_type}{default \code{"rooftop"}. Must be one of \code{"rooftop"} or \code{"street"}.
Optional.}

\item{lang_code}{default \code{NULL}. An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{source_country}{default \code{NULL}. An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{preferred_label_values}{default NULL. Must be one of \code{"postalCity"}
or \code{"localCity"}. Optional.}

\item{magic_key}{a unique identifier returned from \code{\link[=suggest_places]{suggest_places()}}.
When a \code{magic_key} is provided, results are returned faster. Optional.}

\item{geocoder}{default \code{\link[=default_geocoder]{default_geocoder()}}.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}

\item{.progress}{default \code{TRUE}. Whether a progress bar should be provided.}
}
\value{
An \code{sf} object with 60 columns.
}
\description{
Given an address, returns geocode result candidates.
}
\details{
Utilizes the \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-find-address-candidates.htm}{\verb{/findAddressCandidates}} endpoint.

The endpoint can only handle one request at a time. To
make the operation as performant as possible, requests are sent in parallel
using \code{\link[httr2:req_perform_parallel]{httr2::req_perform_parallel()}}. The JSON responses are then processed
using Rust and returned as an sf object.
}
\examples{
candidates_from_single <- find_address_candidates(
  single_line = "Bellwood Coffee, 1366 Glenwood Ave SE, Atlanta, GA, 30316, USA"
)

candidates_from_parts <- find_address_candidates(
  address = c("Bellwood Coffee", "Joe's coffeehouse"),
  address2 = c("1366 Glenwood Ave SE", "510 Flat Shoals Ave"),
  city = "Atlanta",
  region = "GA",
  postal = "30316",
  country_code = "USA"
)

str(candidates_from_parts)

}
