% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aread.R
\name{aread}
\alias{aread}
\title{Read Artifact Given as a md5hash from a Repository}
\usage{
aread(md5hash)
}
\arguments{
\item{md5hash}{A character with at least trhee components, GitHub user name, GitHub repository and name of the artifact assigned to the artifact as a result of a cryptographical hash function with MD5 algorithm, or it's abbreviation.}
}
\description{
\code{aread} reads an artifact from a Github \link{Repository}. It's a wrapper around
\link{loadFromGithubRepo}.
}
\details{
Function \code{aread} read artifact (by the \code{md5hash}) from GitHub Repository.
It uses the function \link{loadFromGithubRepo} with different paramter's specification.
}
\examples{
\dontrun{
# read the object
pl <- aread("pbiecek/graphGallery/2166dfbd3a7a68a91a2f8e6df1a44111")
# plot it
pl
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}};
  \code{\link{archivist-package}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveSetToRepo}};
  \code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
  \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

