% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summaryRepo.R
\name{summaryLocalRepo}
\alias{summaryGithubRepo}
\alias{summaryLocalRepo}
\title{View the Summary of a Repository}
\usage{
summaryLocalRepo(repoDir = NULL)

summaryGithubRepo(repo = NULL, user = NULL, branch = "master",
  repoDirGit = FALSE)
}
\arguments{
\item{repoDir}{A character denoting an existing directory of a Repository for which a summary will be returned.
If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{repo}{Only if working with a Github repository. A character containing a name of a Github repository on which the Repository is archived.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{Only if working with a Github repository. A character containing a name of a Github user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{Only if working with a Github repository. A character containing a name of
Github Repository's branch on which a Repository is archived. Default \code{branch} is \code{master}.}

\item{repoDirGit}{Only if working with a Github repository. A character containing a name of a directory on Github repository
on which the Repository is stored. If the Repository is stored in main folder on Github repository, this should be set
to \code{repoDirGit = FALSE} as default.}
}
\value{
An object of class \code{repository} which can be printed: \code{print(object)}.
}
\description{
\code{summaryRepo} summaries the current state of a \link{Repository}.
}
\details{
\code{summaryRepo} summaries the current state of a \link{Repository}. Recommended to use
\code{print( summaryRepo ) )}. See examples.
}
\note{
If the same artifact was archived many times it is counted as one artifact or database in \code{print(summaryRepo)}.

If \code{repo} and \code{user} are set to \code{NULL} (as default) in Github mode then global parameters
set in \link{setGithubRepo} function are used.
}
\examples{
# objects preparation
\dontrun{
# data.frame object
data(iris)

# ggplot/gg object
library(ggplot2)
df <- data.frame(gp = factor(rep(letters[1:3], each = 10)),y = rnorm(30))
library(plyr)
ds <- ddply(df, .(gp), summarise, mean = mean(y), sd = sd(y))
myplot123 <- ggplot(df, aes(x = gp, y = y)) +
  geom_point() +  geom_point(data = ds, aes(y = mean),
               colour = 'red', size = 3)

# lm object
model <- lm(Sepal.Length~ Sepal.Width + Petal.Length + Petal.Width, data= iris)


# lda object
library(MASS)

Iris <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]),
                  Sp = rep(c("s","c","v"), rep(50,3)))
train <- c(8,83,115,118,146,82,76,9,70,139,85,59,78,143,68,
           134,148,12,141,101,144,114,41,95,61,128,2,42,37,
           29,77,20,44,98,74,32,27,11,49,52,111,55,48,33,38,
           113,126,24,104,3,66,81,31,39,26,123,18,108,73,50,
           56,54,65,135,84,112,131,60,102,14,120,117,53,138,5)
lda1 <- lda(Sp ~ ., Iris, prior = c(1,1,1)/3, subset = train)

# qda object
tr <- c(7,38,47,43,20,37,44,22,46,49,50,19,4,32,12,29,27,34,2,1,17,13,3,35,36)
train <- rbind(iris3[tr,,1], iris3[tr,,2], iris3[tr,,3])
cl <- factor(c(rep("s",25), rep("c",25), rep("v",25)))
qda1 <- qda(train, cl)

# glmnet object
library( glmnet )

zk=matrix(rnorm(100*20),100,20)
bk=rnorm(100)
glmnet1=glmnet(zk,bk)

# creating example Repository - that examples will work

exampleRepoDir <- tempdir()
createEmptyRepo(repoDir = exampleRepoDir)
saveToRepo(myplot123, repoDir=exampleRepoDir)
saveToRepo(iris, repoDir=exampleRepoDir)
saveToRepo(model, repoDir=exampleRepoDir)

# summary examples

summaryLocalRepo( repoDir = exampleRepoDir )

# let's add more artifacts

saveToRepo(glmnet1, repoDir=exampleRepoDir)
saveToRepo(lda1, repoDir=exampleRepoDir)
(qda1Md5hash <- saveToRepo(qda1, repoDir=exampleRepoDir))

# summary now

summaryLocalRepo( repoDir = exampleRepoDir )

# what if we remove an artifact

rmFromRepo(qda1Md5hash, repoDir = exampleRepoDir)

# summary now

summaryLocalRepo( repoDir = exampleRepoDir )

#
# Github version
#

x <- summaryGithubRepo( user="pbiecek", repo="archivist")
print( x )

# removing an example Repository

deleteRepo( exampleRepoDir )

rm( exampleRepoDir )

# many archivist-like Repositories on one Github repository

summaryGithubRepo(user="MarcinKosinski", repo="Museum",
branch="master", repoDirGit="ex2" )

}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveSetToRepo}};
  \code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
  \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}}; \code{\link{zipGithubRepo}},
  \code{\link{zipLocalRepo}}
}

