% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRemoteHook.R
\name{getRemoteHook}
\alias{getRemoteHook}
\title{Get http Hook for Remote Repo}
\usage{
getRemoteHook(repo = aoptions("repo"), user = aoptions("user"),
  branch = aoptions("branch"), subdir = aoptions("subdir"),
  repoType = aoptions("repoType"))
}
\arguments{
\item{repo}{A character containing a name of a Git repository on which the Repository is archived.}

\item{user}{A character containing a name of a Git user on whose account the \code{repo} is created.}

\item{branch}{A character containing a name of Git Repository's branch on which the Repository is archived. 
Default \code{branch} is \code{master}.}

\item{subdir}{A character containing a name of a directory on Git repository 
on which the Repository is stored. If the Repository is stored in main folder on Git repository, this should be set 
to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}
}
\description{
\code{getRemoteHook} returns http adress of the remote \link{Repository}.
Then it can be used to download artifacts from the remote \link{Repository}.
}
\examples{

\dontrun{
# objects preparation
getRemoteHook("graphGallery", "pbiecek")
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

