% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archivist-package.R
\docType{package}
\name{archivist-package}
\alias{archivist-package}
\title{Tools for Storing, Restoring and Searching for R Objects}
\description{
Data exploration and modelling is a process in which a lot of data artifacts are produced. 
Artifacts like: subsets, data aggregates, plots, statistical models, different  versions of data sets and different versions of results. 
The more projects we work on, the more artifacts are produced and the harder it is to manage these artifacts. 

Archivist helps to store and manage artifacts created in R.

Archivist allows you to store selected artifacts as binary files
along with their metadata and relations.
Archivist allows you to share artifacts with others, either through a shared folder or github.
Archivist allows you to look for artifacts by using its class, 
name, date of creation or other properties.
It also facilitates restoring such artifacts.
Archivist allows you to check if a new artifact is the exact 
copy of the one that was produced some time ago.
This might be useful either for testing or caching.

The list of main use cases is available here \href{https://github.com/pbiecek/archivist}{https://github.com/pbiecek/archivist}.
}
\details{
For more detailed information visit \pkg{archivist} \code{wiki} on 
\href{https://github.com/pbiecek/archivist/wiki}{Github}.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\section{Blogging}{

 
We have prepared history of blog posts and conference talks about \pkg{archivist} under this link 
\href{http://pbiecek.github.io/archivist/articles/posts.html}{http://pbiecek.github.io/archivist/articles/posts.html}
}

\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Przemyslaw Biecek [aut, cre] \email{przemyslaw.biecek@gmail.com} \cr
Marcin Kosinski [aut] \email{m.p.kosinski@gmail.com} \cr
Witold Chodor [ctb] \email{witold.chodor@gmail.com}
}
\concept{archivist}
