% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{county_raw_fips}
\alias{county_raw_fips}
\title{Download raw prescription data for specified county (by county FIPS code) into R}
\usage{
county_raw_fips(fips = "01001", key = "WaPo")
}
\arguments{
\item{fips}{Filter the data to only this county (e.g. ‘01001’ for Autauga, Alabama)}

\item{key}{Key needed to make query successful}
}
\description{
Data from from non-contiguous states not yet processed and available.
}
\examples{
\donttest{
library(arcos)

autauga_al <- county_raw_fips(fips="01001", key="WaPo")

head(autauga_al)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other raw data: \code{\link{county_raw}},
  \code{\link{pharmacy_raw}}, \code{\link{raw_data}}
}
\concept{raw data}
