% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_layers.R
\name{get_spatial_layer}
\alias{get_spatial_layer}
\title{Retrieve a spatial layer from an ArcGIS REST API}
\usage{
get_spatial_layer(
  url,
  out_fields = c("*"),
  where = "1=1",
  token = "",
  sf_type = NULL,
  ...
)
}
\arguments{
\item{url}{A character string of the url for the layer to pull}

\item{out_fields}{A character string of the fields to pull for each layer}

\item{where}{A character string of the where condition. Default is 1=1}

\item{token}{A character string of the token (if needed)}

\item{sf_type}{A character string specifying the layer geometry to convert to
sf ("esriGeometryPolygon", "esriGeometryPoint", "esriGeometryPolyline"),
if NULL (default) the server will take its best guess}

\item{...}{Additional arguements to pass to the ArcGIS REST POST request}
}
\value{
An object of class "sf" of the appropriate layer
}
\description{
This function retrieves spatial layers present an ArcGIS
REST services API located at.
}
\details{
This is the core function of this package. It retrieves spatial layers from
an ArcGIS REST API designated by the URL. Additional querying features can
be passed such as a SQL WHERE statement (\code{where} argument) as well as
spatial queries or any other types of queries that the ArcGIS REST API
accepts using \code{...}. However, for easier spatial querying see
\code{\link{get_layers_by_spatial}}.

All of the querying parameters are sent via a POST request to the URL, so
if there are issues with passing additional parameters via \code{...}
first determine how they fit into the POST request and make adjustments as
needed. This syntax can be tricky if you're not used to it.
}
\examples{
\dontrun{
# lava flows on Reykjanes (pr. 'rake-yah-ness') peninsula in Iceland
base_url <- "https://arcgisserver.isor.is:6443/arcgis/rest/services"
reykjanes_path <- "vi/uttekt_eldstodva_allt_2/MapServer/5"
reykjanes_url <- paste(base_url, reykjanes_path, sep = "/")
lava_flows <- get_spatial_layer(reykjanes_url)
plot_layer(lava_flows, outline_poly = reykjanes)
plot_layer(lava_flows, outline_poly = reykjanes) +
  ggplot2::geom_sf(data = iceland_poly, fill = NA)
}

}
