% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_missing_data.R
\name{impute_missing_data}
\alias{impute_missing_data}
\title{Impute missing data}
\usage{
impute_missing_data(
  acc,
  wear_flag,
  valid_day_flag,
  imputeFromValidDaysOnly = TRUE
)
}
\arguments{
\item{acc}{A numeric vector. A minute-level activity counts data vector.
It is assumed
to be in midnight-to-midnight format, meaning its vector length
is a multiple of number of minutes in a full day
(1440; see \code{midnight_to_midnight()}).}

\item{wear_flag}{An integer vector.
Wear/non-wear flag (\code{1}/\code{0}) for each minute of activity
counts data. It is assumed
to be in midnight-to-midnight format, meaning its vector length
is a multiple of number of minutes in a full day
(1440). See \code{midnight_to_midnight()}, \code{get_wear_flag()}.}

\item{valid_day_flag}{An integer vector.
Valid/non-valid day flag (\code{1}/\code{0}) for each minute of activity
counts data. It is assumed
to be in midnight-to-midnight format, meaning its vector length
is a multiple of number of minutes in a full day
(1440).
 See \code{arctools::midnight_to_midnight()},
 \code{arctools::get_valid_day_flag()}.}

\item{imputeFromValidDaysOnly}{A logical scalar. Whether or not data from
valid days only should be used for computing "average day profile"
used for imputation.}
}
\value{
A numeric vector. A minute-level activity counts data vector
with data imputed for minutes identified as non-wear in days identified as valid
}
\description{
Impute missing data in minute-level activity counts data vector based on
"average day profile".
}
\details{
An "average day profile" is computed as average across minutes identified
as wear and from valid days
(see param. \code{imputeFromValidDaysOnly}). Activity counts data are imputed
from "average day profile" for minutes identified as non-wear in days
identified as valid, except for minutes before/after data
collection start/end which remain \code{NA}.

Theoretically, it is possible that all valid days of data collection have
non-wear flag for the some minute(s) (i.e., somebody is always
taking off the watch for the same few minutes during a day) so there is no
data to use to compute imputation values from. If it happens, then method
uses 0 as imputation value(s).
}
\examples{
## Read exemplary data
fpath_i <- system.file("extdata", extdata_fnames[1], package = "arctools")
dat_i   <- as.data.frame(data.table::fread(fpath_i))
acc     <- dat_i$vectormagnitude
acc_ts  <- lubridate::ymd_hms(dat_i$timestamp)
## Get acc data vector in "midnight_to_midnight" format
acc <- midnight_to_midnight(acc, acc_ts)
## Get wear/non-wear flag
wear_flag <- get_wear_flag(acc)
## Get valid/non-valid day flag
valid_day_flag <- get_valid_day_flag(wear_flag)
## Impute missing data in acc data vector
acc_imputed <- impute_missing_data(acc, wear_flag, valid_day_flag)
## Compare mean acc before/after imputation
c(mean(acc, na.rm = TRUE), mean(acc_imputed, na.rm = TRUE))

}
