\name{nifti.header-class}
\Rdversion{1.1}
\docType{class}
\alias{nifti.header-class}
\alias{.nifti.header.aux_file,nifti.header-method}
\alias{.nifti.header.aux_file<-,nifti.header-method}
\alias{.nifti.header.bitpix,nifti.header-method}
\alias{.nifti.header.bitpix<-,nifti.header-method}
\alias{.nifti.header.cal_max,nifti.header-method}
\alias{.nifti.header.cal_max<-,nifti.header-method}
\alias{.nifti.header.cal_min,nifti.header-method}
\alias{.nifti.header.cal_min<-,nifti.header-method}
\alias{.nifti.header.data_type,nifti.header-method}
\alias{.nifti.header.data_type<-,nifti.header-method}
\alias{.nifti.header.data.signed,nifti.header-method}
\alias{.nifti.header.data.signed<-,nifti.header-method}
\alias{.nifti.header.data.type,nifti.header-method}
\alias{.nifti.header.data.type<-,nifti.header-method}
\alias{.nifti.header.datatype,nifti.header-method}
\alias{.nifti.header.datatype<-,nifti.header-method}
\alias{.nifti.header.db_name,nifti.header-method}
\alias{.nifti.header.db_name<-,nifti.header-method}
\alias{.nifti.header.descrip,nifti.header-method}
\alias{.nifti.header.descrip<-,nifti.header-method}
\alias{.nifti.header.dim_info,nifti.header-method}
\alias{.nifti.header.dim_info<-,nifti.header-method}
\alias{.nifti.header.dims,nifti.header-method}
\alias{.nifti.header.dims<-,nifti.header-method}
\alias{.nifti.header.endian,nifti.header-method}
\alias{.nifti.header.endian<-,nifti.header-method}
\alias{.nifti.header.extension,nifti.header-method}
\alias{.nifti.header.extension<-,nifti.header-method}
\alias{.nifti.header.extents,nifti.header-method}
\alias{.nifti.header.extents<-,nifti.header-method}
\alias{.nifti.header.filename,nifti.header-method}
\alias{.nifti.header.filename<-,nifti.header-method}
\alias{.nifti.header.filetype,nifti.header-method}
\alias{.nifti.header.filetype<-,nifti.header-method}
\alias{.nifti.header.fullpath,nifti.header-method}
\alias{.nifti.header.fullpath<-,nifti.header-method}
\alias{.nifti.header.glmax,nifti.header-method}
\alias{.nifti.header.glmax<-,nifti.header-method}
\alias{.nifti.header.glmin,nifti.header-method}
\alias{.nifti.header.glmin<-,nifti.header-method}
\alias{.nifti.header.gzipped,nifti.header-method}
\alias{.nifti.header.gzipped<-,nifti.header-method}
\alias{.nifti.header.intent_code,nifti.header-method}
\alias{.nifti.header.intent_code<-,nifti.header-method}
\alias{.nifti.header.intent_name,nifti.header-method}
\alias{.nifti.header.intent_name<-,nifti.header-method}
\alias{.nifti.header.intent_p1,nifti.header-method}
\alias{.nifti.header.intent_p1<-,nifti.header-method}
\alias{.nifti.header.intent_p2,nifti.header-method}
\alias{.nifti.header.intent_p2<-,nifti.header-method}
\alias{.nifti.header.intent_p3,nifti.header-method}
\alias{.nifti.header.intent_p3<-,nifti.header-method}
\alias{.nifti.header.magic,nifti.header-method}
\alias{.nifti.header.magic<-,nifti.header-method}
\alias{.nifti.header.pixdim,nifti.header-method}
\alias{.nifti.header.pixdim<-,nifti.header-method}
\alias{.nifti.header.qform_code,nifti.header-method}
\alias{.nifti.header.qform_code<-,nifti.header-method}
\alias{.nifti.header.qoffset_x,nifti.header-method}
\alias{.nifti.header.qoffset_x<-,nifti.header-method}
\alias{.nifti.header.qoffset_y,nifti.header-method}
\alias{.nifti.header.qoffset_y<-,nifti.header-method}
\alias{.nifti.header.qoffset_z,nifti.header-method}
\alias{.nifti.header.qoffset_z<-,nifti.header-method}
\alias{.nifti.header.quatern_b,nifti.header-method}
\alias{.nifti.header.quatern_b<-,nifti.header-method}
\alias{.nifti.header.quatern_c,nifti.header-method}
\alias{.nifti.header.quatern_c<-,nifti.header-method}
\alias{.nifti.header.quatern_d,nifti.header-method}
\alias{.nifti.header.quatern_d<-,nifti.header-method}
\alias{.nifti.header.regular,nifti.header-method}
\alias{.nifti.header.regular<-,nifti.header-method}
\alias{.nifti.header.scl_inter,nifti.header-method}
\alias{.nifti.header.scl_inter<-,nifti.header-method}
\alias{.nifti.header.scl_slope,nifti.header-method}
\alias{.nifti.header.scl_slope<-,nifti.header-method}
\alias{.nifti.header.session_error,nifti.header-method}
\alias{.nifti.header.session_error<-,nifti.header-method}
\alias{.nifti.header.sform_code,nifti.header-method}
\alias{.nifti.header.sform_code<-,nifti.header-method}
\alias{.nifti.header.sizeof_hdr,nifti.header-method}
\alias{.nifti.header.sizeof_hdr<-,nifti.header-method}
\alias{.nifti.header.slice_code,nifti.header-method}
\alias{.nifti.header.slice_code<-,nifti.header-method}
\alias{.nifti.header.slice_duration,nifti.header-method}
\alias{.nifti.header.slice_duration<-,nifti.header-method}
\alias{.nifti.header.slice_end,nifti.header-method}
\alias{.nifti.header.slice_end<-,nifti.header-method}
\alias{.nifti.header.slice_start,nifti.header-method}
\alias{.nifti.header.slice_start<-,nifti.header-method}
\alias{.nifti.header.srow_x,nifti.header-method}
\alias{.nifti.header.srow_x<-,nifti.header-method}
\alias{.nifti.header.srow_y,nifti.header-method}
\alias{.nifti.header.srow_y<-,nifti.header-method}
\alias{.nifti.header.srow_z,nifti.header-method}
\alias{.nifti.header.srow_z<-,nifti.header-method}
\alias{.nifti.header.toffset,nifti.header-method}
\alias{.nifti.header.toffset<-,nifti.header-method}
\alias{.nifti.header.version,nifti.header-method}
\alias{.nifti.header.version<-,nifti.header-method}
\alias{.nifti.header.vox_offset,nifti.header-method}
\alias{.nifti.header.vox_offset<-,nifti.header-method}
\alias{.nifti.header.xyzt_units,nifti.header-method}
\alias{.nifti.header.xyzt_units<-,nifti.header-method}

\title{arf3DS4 "nifti.header" class }
\description{The arf3DS4 "nifti.header" class contains the header information of an ANALYZE/NIFTI functional volume.}
\section{Objects}{
Objects can be created by calls of the form \code{new("nifti.header", ...)}.
}
\section{Slots}{
	 \describe{
    \item{\code{sizeof_hdr}:}{<nifti> Size of the header file.}
    \item{\code{data_type}:}{<nifti> Type of data (representation). }
    \item{\code{db_name}:}{<nifti> db_name.}
    \item{\code{extents}:}{<nifti> extents}
    \item{\code{session_error}:}{<nifti> session error. }
    \item{\code{regular}:}{<nifti> regular }
    \item{\code{dim_info}:}{<nifti> MRI slice ordering. }
    \item{\code{dims}:}{<nifti> Data array dimensions. }
    \item{\code{intent_p1}:}{<nifti> 1st intent parameter.}
    \item{\code{intent_p2}:}{<nifti> 2nd intent parameter.}
    \item{\code{intent_p3}:}{<nifti> 3rd intent parameter.}
    \item{\code{intent_code}:}{<nifti> Intent code.}
    \item{\code{datatype}:}{<nifti> Data type.}
    \item{\code{bitpix}:}{<nifti> Number of bits per voxel.}
    \item{\code{slice_start}:}{<nifti> First slice index. }
    \item{\code{pixdim}:}{<nifti> Grid spacing (single voxel dimensions).}
    \item{\code{vox_offset}:}{<nifti> Offset in the .nii file. }
    \item{\code{scl_slope}:}{<nifti> Data scaling, slope. }
    \item{\code{scl_inter}:}{<nifti> Data scaling, offset. }
    \item{\code{slice_end}:}{<nifti> Last slice index. }
    \item{\code{slice_code}:}{<nifti> Slice timing order. }
    \item{\code{xyzt_units}:}{<nifti> Units of single voxel dimensions. }
    \item{\code{cal_max}:}{<nifti> Maximum display intensity. }
    \item{\code{cal_min}:}{<nifti> Minimum display intensity. }
    \item{\code{slice_duration}:}{<nifti> Time for one slice (TR).}
    \item{\code{toffset}:}{<nifti> Shift in time. }
    \item{\code{glmax}:}{<nifti> glmax. }
    \item{\code{glmin}:}{<nifti> glmin. }
    \item{\code{descrip}:}{<nifti> Description of file.}
    \item{\code{aux_file}:}{<nifti> An auxilliary filename. }
    \item{\code{qform_code}:}{<nifti> q_form code. }
    \item{\code{sform_code}:}{<nifti> s_form code.}
    \item{\code{quatern_b}:}{<nifti> quaternion b parameter. }
    \item{\code{quatern_c}:}{<nifti> quaternion c parameter. }
    \item{\code{quatern_d}:}{<nifti> quaternion d parameter. }
    \item{\code{qoffset_x}:}{<nifti> q offset x parameter. }
    \item{\code{qoffset_y}:}{<nifti> q offset y parameter. }
    \item{\code{qoffset_z}:}{<nifti> q offset z parameter.}
    \item{\code{srow_x}:}{<nifti> 1st row affine transformation. }
    \item{\code{srow_y}:}{<nifti> 2nd row affine transformation.  }
    \item{\code{srow_z}:}{<nifti> 3rd row affine transformation. }
    \item{\code{intent_name}:}{<nifti> Meaning of data. }
    \item{\code{magic}:}{<nifti> nifti magicstring.  }
    \item{\code{data.type}:}{<arf3DS4> Data type. }
    \item{\code{data.signed}:}{<arf3DS4> Signed data. }
    \item{\code{fullpath}:}{<arf3DS4> Full path of datafile. }
    \item{\code{filename}:}{<arf3DS4> Filename. }
    \item{\code{filetype}:}{<arf3DS4> Type of file. }
    \item{\code{extension}:}{<arf3DS4> File extension. }
    \item{\code{gzipped}:}{<arf3DS4> Is the file gzipped? }
    \item{\code{endian}:}{<arf3DS4> Endianness of file. }
    \item{\code{version}:}{Object of class "version" (see \code{\linkS4class{version}})}
  }
}
\section{Extends}{
Class \code{"\linkS4class{nifti.fileinfo}"}, directly.
}
\section{Methods}{
 Standard arf3DS4 accessor and replacement functions can be used to access and replace slots. 
  \describe{
 	\item{access}{\code{.classname.slotname(object)}}
    \item{replace}{\code{.classname.slotname(object)<-}}
 	 }
 In this case classname is "nifti.header" and slotname is for example "dims". So to access the "dims" slot of an r-object "myniftiheader"  (of class "nifti.header") type \code{.nifti.header.dims(myfniftiheader)}.
}
\references{ See the Nifti homepage (\url{http://nifti.nimh.nih.gov/}) for more information on the nifti filetype.}
\author{ Wouter D. Weeda - w.d.weeda@gmail.com }
\seealso{
	\code{\linkS4class{fmri.data}},\code{\linkS4class{nifti.fileinfo}}
}
\examples{
showClass("nifti.header")
}
\keyword{classes}

