% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pw.r
\name{hashing}
\alias{hashing}
\alias{pw_hash}
\alias{pw_check}
\title{Password Hashing}
\usage{
pw_hash(pass, type = "i")

pw_check(hash, pass)
}
\arguments{
\item{pass}{The (plaintext) password.}

\item{type}{Choice of algorithm; choices are "i" and "d".}

\item{hash}{The hashed password; this is the output of \code{pw_hash()}.}
}
\value{
\code{pw_hash()} returns a hash to be used as an input to \code{pw_check()}.

\code{pw_check()} returns \code{TRUE} or \code{FALSE}, whether or not
the plaintext password matches its hash.
}
\description{
Basic password hashing.  Use \code{pw_hash()} to hash and \code{pw_check()}
to compare a possible password with the hashed password.
}
\details{
For more hashing options, see the sodium and bcrypt.


This uses the argon2 (i or d variety) hash algorithm.  See references for
details and implementation source code (also bundled with this package).

Our binding uses a 512 bit salt with data generated from MT, a "time cost"
(number of passes) of 16, "memory cost" of 8192 MiB, and 1 thread.
}
\examples{
\dontrun{
library(argon2)

pass <- "myPassw0rd!"
hash <- pw_hash(pass)
hash # store this

pw_check(hash, pass)
pw_check(hash, "password")
pw_check(hash, "1234")
}

}
\references{
Biryukov, A., Dinu, D. and Khovratovich, D., 2015. Fast and
Tradeoff-Resilient Memory-Hard Functions for Cryptocurrencies and Password
Hashing. IACR Cryptology ePrint Archive, 2015, p.430.

Reference implementation \url{https://github.com/P-H-C/phc-winner-argon2}
}
