# Highest density regions

    Code
      interval_hdr(faithful$eruptions)
    Output
              start      end    p
      [1,] 1.307160 2.837942 0.33
      [2,] 3.150567 5.295819 0.62

# Bayesian credible interval

    Code
      interval_credible(faithful$eruptions)
    Output
           start  end    p
      [1,] 1.733 4.85 0.95

# Confidence interval for the mean

    Code
      confidence_mean(x, type = "student")
    Output
         lower    upper 
      17.91768 22.26357 

---

    Code
      confidence_mean(x, type = "normal")
    Output
         lower    upper 
      18.00243 22.17882 

# Confidence interval for binomial proportions

    Code
      confidence_binomial(118, n = 236)
    Output
          lower     upper 
      0.4362086 0.5637914 

---

    Code
      confidence_multinomial(x)
    Output
                lower     upper
      [1,] 0.12234021 0.2276598
      [2,] 0.30308797 0.4369120
      [3,] 0.06663649 0.1533635
      [4,] 0.27911853 0.4108815

---

    Code
      confidence_multinomial(x, corrected = TRUE)
    Output
                lower     upper
      [1,] 0.11984021 0.2301598
      [2,] 0.30058797 0.4394120
      [3,] 0.06413649 0.1558635
      [4,] 0.27661853 0.4133815

# Bootstrap

    Code
      bootstrap_summary
    Output
         original        mean        bias       error 
       0.07651681  0.05439040 -0.02212641  0.19517006 

---

    Code
      bootstrap_values
    Output
        [1]  0.274803536  0.271761759  0.131918811 -0.108350186 -0.407722040
        [6]  0.474370950  0.096520144  0.140542686  0.048469812  0.045673600
       [11]  0.098911690  0.174660229  0.407774218  0.076149892  0.233883643
       [16] -0.158214771  0.296334314 -0.236746678 -0.027278798  0.140680055
       [21]  0.084317514  0.131248858 -0.126159227  0.351657449  0.130019851
       [26] -0.064196657  0.049937514 -0.166241173 -0.085116371  0.003131881
       [31]  0.159010387  0.126015372  0.175198395  0.127748767 -0.047995525
       [36]  0.245223426 -0.029654335  0.153690734  0.372854685 -0.061229774
       [41]  0.102818533  0.037641950  0.125330950 -0.082734254 -0.081537996
       [46]  0.003646969  0.096332439  0.116993888 -0.176113259  0.345299218
       [51]  0.595379927 -0.311485051  0.093283378  0.342125925  0.001140435
       [56]  0.246825067 -0.173706701  0.113309462  0.338231445 -0.425915621
       [61]  0.446095061  0.156535443 -0.266725129  0.175778042  0.201231074
       [66] -0.065400705  0.015916353  0.257033280 -0.111331877  0.073891696
       [71] -0.004623160 -0.326442795  0.048737537  0.005317883 -0.053255377
       [76]  0.081287636 -0.013228710  0.344409439 -0.125705295 -0.181941858
       [81]  0.118077490 -0.154583474  0.035114092  0.026580327 -0.119802041
       [86] -0.197818974  0.107870115  0.253120777 -0.199949361  0.050689044
       [91]  0.002231045  0.309152956 -0.390878169  0.027390498  0.026426616
       [96]  0.223192535 -0.022840641 -0.146577129 -0.014807361  0.038401655

# Jackknife

    Code
      jackknife(x, do = mean)
    Output
        original       mean       bias      error 
      0.07651681 0.07651681 0.00000000 0.18647363 

---

    Code
      jackknife(x, do = mean, f = function(x) {
        x
      })
    Output
       [1]  0.04972670  0.04320369  0.08629682  0.10441228  0.04865520  0.17622590
       [7]  0.04738093  0.09508001  0.09549979  0.12892938  0.08666232 -0.01510399
      [13]  0.06103728  0.05316420  0.12004569  0.03754928  0.12719441  0.09799546
      [19]  0.02155913  0.06482171

