% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/5_SimulateModels.R
\name{plot.SimulatedModel}
\alias{plot.SimulatedModel}
\alias{plot.SimulatedNetwork}
\alias{plot.list}
\title{#Shows a plot of the evolution of a variable during the simulation
#
#}
\usage{
\method{plot}{SimulatedModel}(x, minrange = 1, maxrange, var = "L",
  graphics = "ggplot2", depth = maxrange - minrange, ...)

\method{plot}{SimulatedNetwork}(x, minrange = 1, maxrange, var = "L",
  graphics = "ggplot2", depth = maxrange - minrange, nSimulation = NULL,
  ...)

\method{plot}{list}(x, minrange = 1, maxrange, var = "L",
  graphics = "ggplot2", depth = maxrange - minrange + 1, nSimulation = 1,
  ...)
}
\arguments{
\item{x}{Simulated Model
#}

\item{minrange}{Number of customer needed to establish the start of the plot
#}

\item{maxrange}{Number of customer needed to establish the end of the plot
#}

\item{var}{This variable indicates the parameter of the queue to show in graphic (L, Lq, W, Wq, Clients, Intensity)
#}

\item{graphics}{Type of graphics: "graphics" use the basic R plot and "ggplot2" the library ggplot2
#}

\item{depth}{Number of points printed in the plot
#}

\item{...}{Further arguments passed to or from other methods.
#}

\item{nSimulation}{Only used when the var param is equal to "Clients". Selects one of the multiple simulations to show the evolution of the Clients.
#}
}
\description{
#Shows a plot of the evolution of a variable during the simulation
#
#
}
\details{
\code{plot.SimulatedModel} implements the function for an object of class SimulatedModel.

\code{plot.SimulatedNetwork} implements the function for an object of class SimulatedNetwork.

\code{plot.list} implements the function for an object of class list
}

