% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/1_ModelsHeader.R, R/2_SimpleModels.R, R/3_ComplexModels.R
\name{Qn}
\alias{Qn}
\alias{Qn.M_M_1_INF_H}
\alias{Qn.M_M_1_K}
\alias{Qn.M_M_S_INF_H}
\alias{Qn.M_M_S_INF_H_Y}
\alias{Qn.M_M_S_K}
\alias{Qn.MarkovianModel}
\title{Steady-state probability of finding n customers in the system when a new customer arrives}
\usage{
Qn(qm, n)
}
\arguments{
\item{qm}{Queueing model}

\item{n}{Customers}
}
\value{
\ifelse{latex}{\deqn{Q_n}}{\out{<i>Q<sub>n</sub></i>}}
}
\description{
Returns the probability of having n customers in the system at the moment of the
arrival of a customer.
}
\section{Methods (by class)}{
\itemize{
\item \code{MarkovianModel}: Implements the default method (generates a message)

\item \code{M_M_1_K}: Implements the method for a M/M/1/K queueing model

\item \code{M_M_S_K}: Implements the method for a M/M/S/K queueing model

\item \code{M_M_1_INF_H}: Implements the method for a M/M/1/\eqn{\infty}/H queueing model

\item \code{M_M_S_INF_H}: Implements the method for a M/M/s/\eqn{\infty}/H queueing model

\item \code{M_M_S_INF_H_Y}: Implements the method for a M/M/s/\eqn{\infty}/H with Y replacements queueing model
}}
\examples{
#Probability of having one customer in the
#queue
Qn(M_M_1_K(), 1)
Qn(M_M_S_INF_H(), 1)

#You can also get multiple probabilities
#at once
Qn(M_M_1_INF_H(), 0:5)
Qn(M_M_S_K(), 1:3)
}

