context("Combinations with replacement")

test_that("combinations with replacement - ncombinations", {
    L = c(LETTERS, letters)
    expect_equal(ncombinations(8, 3, replace = TRUE), 120)
    expect_equal(ncombinations(x = LETTERS[1:8], k = 3, replace = TRUE), 120)
    expect_error(ncombinations(40, 10, replace = TRUE), "integer overflow")
    expect_error(ncombinations(x = L[1:40], k = 10, replace = TRUE), "integer overflow")
    expect_equal(ncombinations(40, 10, replace = TRUE, bigz = TRUE), gmp::as.bigz("8217822536"))
    expect_equal(ncombinations(8, 0, replace = TRUE), 1)
    expect_equal(ncombinations(4, 5, replace = TRUE), 56)
    expect_error(ncombinations(6, -1, replace = TRUE), "expect non-negative integer")
    expect_error(ncombinations(6, 1.5, replace = TRUE), "expect non-negative integer")

    expect_equal(ncombinations(0, 0, replace = TRUE), 1)
    expect_equal(ncombinations(0, 1, replace = TRUE), 0)
})

test_that("Combinations with replacement - combinations", {
    comb <- combinations(8, 3, replace= TRUE)
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], rep(1, 3))
    expect_equal(comb[120, ], rep(8, 3))

    comb <- combinations(8, 3, replace= TRUE, type = "r")
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], rep(1, 3))
    expect_equal(comb[120, ], rep(8, 3))

    comb <- combinations(8, 3, replace= TRUE, type = "c")
    expect_equal(ncol(comb), 120)
    expect_equal(nrow(comb), 3)
    expect_equal(comb[, 1], rep(1, 3))
    expect_equal(comb[, 120], rep(8, 3))

    comb <- combinations(8, 3, replace= TRUE, type = "l")
    expect_equal(length(comb), 120)
    expect_equal(comb[[1]], rep(1, 3))
    expect_equal(comb[[120]], rep(8, 3))

    comb <- combinations(x = LETTERS[1:8], k = 3, replace= TRUE)
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], LETTERS[rep(1, 3)])
    expect_equal(comb[120, ], LETTERS[rep(8, 3)])

    expect_error(combinations(40, 10, replace = TRUE), "too many results")
    expect_error(combinations(5, -1, replace= TRUE), "expect non-negative integer")
    expect_error(combinations(5, 1.5, replace= TRUE), "expect non-negative integer")
    expect_equal(dim(combinations(8, 0, replace= TRUE)), c(1, 0))
    expect_equal(dim(combinations(4, 5, replace= TRUE)), c(56, 5))
    expect_equal(dim(combinations(0, 0, replace= TRUE)), c(1, 0))
    expect_equal(dim(combinations(0, 1, replace= TRUE)), c(0, 1))
})

test_that("Combinations with replacement - icombinations", {
    icomb <- icombinations(8, 3, replace= TRUE)
    perm <- combinations(8, 3, replace= TRUE)
    expect_equal(icomb$collect(), perm)
    expect_equal(icomb$getnext(), rep(1, 3))
    expect_equal(icomb$getnext(), c(1, 1, 2))
    icomb$getnext(110)
    expect_equal(nrow(icomb$getnext(10)), 8)
    expect_equal(icomb$getnext(), NULL)

    perm <- combinations(8, 3, replace= TRUE, type = "r")
    expect_equal(icomb$collect(type = "r"), perm)
    expect_equal(icomb$getnext(type = "r"), t(rep(1, 3)))
    expect_equal(icomb$getnext(type = "r"), t(c(1, 1, 2)))
    icomb$getnext(110, type = "r")
    expect_equal(nrow(icomb$getnext(10, type = "r")), 8)
    expect_equal(icomb$getnext(type = "r"), NULL)

    perm <- combinations(8, 3, replace= TRUE, type = "c")
    expect_equal(icomb$collect(type = "c"), perm)
    expect_equal(icomb$getnext(type = "c"), t(t(rep(1, 3))))
    expect_equal(icomb$getnext(type = "c"), t(t(c(1, 1, 2))))
    icomb$getnext(110, type = "c")
    expect_equal(ncol(icomb$getnext(10, type = "c")), 8)
    expect_equal(icomb$getnext(type = "c"), NULL)

    perm <- combinations(8, 3, replace= TRUE, type = "l")
    expect_equal(icomb$collect(type = "l"), perm)
    expect_equal(icomb$getnext(type = "l"), list(rep(1, 3)))
    expect_equal(icomb$getnext(type = "l"), list(c(1, 1, 2)))
    icomb$getnext(110, type = "l")
    expect_equal(length(icomb$getnext(10, type = "l")), 8)
    expect_equal(icomb$getnext(type = "l"), NULL)

    icomb <- icombinations(8, 0, replace= TRUE)
    expect_equal(dim(icomb$collect()), c(1, 0))
    expect_equal(length(icomb$getnext()), 0)
    expect_equal(icomb$getnext(), NULL)
    icomb <- icombinations(4, 5, replace= TRUE)
    expect_equal(nrow(icomb$collect()), 56)
    expect_error(icombinations(5, -1, replace= TRUE), "expect non-negative integer")
    expect_error(icombinations(5, 1.5, replace= TRUE), "expect non-negative integer")
})
