% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-batch-reader.R
\docType{class}
\name{RecordBatchReader}
\alias{RecordBatchReader}
\alias{RecordBatchStreamReader}
\alias{RecordBatchFileReader}
\title{RecordBatchReader classes}
\description{
\code{RecordBatchFileReader} and \code{RecordBatchStreamReader} are
interfaces for generating record batches from different input sources.
}
\section{Factory}{


The \code{RecordBatchFileReader$create()} and \code{RecordBatchStreamReader$create()}
factory methods instantiate the object and
take a single argument, named according to the class:
\itemize{
\item \code{file} A character file name, raw vector, or Arrow file connection object
(e.g. \code{RandomAccessFile}).
\item \code{stream} A raw vector, \link{Buffer}, or \code{InputStream}.
}
}

\section{Methods}{

\itemize{
\item \verb{$read_next_batch()}: Returns a \code{RecordBatch}
\item \verb{$schema()}: Returns a \link{Schema}
\item \verb{$batches()}: Returns a list of \code{RecordBatch}es
\item \verb{$get_batch(i)}: For \code{RecordBatchFileReader}, return a particular batch
by an integer index.
\item \verb{$num_record_batches()}: For \code{RecordBatchFileReader}, see how many batches
are in the file.
}
}

