% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{freqlist}
\alias{freqlist}
\alias{freqlist}
\alias{freqlist.table}
\alias{freqlist.formula}
\alias{print.freqlist}
\title{freqlist}
\usage{
freqlist(object, ...)

\method{freqlist}{table}(object, sparse = FALSE, na.options = c("include",
  "showexclude", "remove"), digits = 2, labelTranslations = NULL,
  groupBy = NULL, ...)

\method{freqlist}{formula}(formula, data, subset, na.action, addNA, exclude,
  drop.unused.levels, ...)

\method{print}{freqlist}(x, ...)
}
\arguments{
\item{object}{An R object, usually of class \code{"table"} or class \code{"xtabs"}}

\item{...}{additional arguments. These are only used in the formula method, and are passed to
the table method.}

\item{sparse}{a logical value indicating whether to keep rows with counts of zero.
The default is \code{FALSE} (drop zero-count rows).}

\item{na.options}{a character string indicating how to handling missing values: \code{"include"}
(include values with NAs in counts and percentages),
\code{"showexclude"} (show NAs but exclude from cumulative counts and all percentages),
\code{"remove"} (remove values with NAs); default is \code{"include"}.}

\item{digits}{a single number indicating the number of digits for percentages (passed to \code{\link{round}}; default is 2.}

\item{labelTranslations}{an optional character string (or list) of labels to use for variable levels when summarizing.
Names will be matched appropriately.}

\item{groupBy}{an optional character string specifying a variable(s) to use for grouping when calculating cumulative
counts and percentages. \code{\link{summary.freqlist}} will also separate by grouping variable for printing.}

\item{formula, data, subset, na.action, addNA, exclude, drop.unused.levels}{Arguments passed to \code{\link[stats]{xtabs}}. Note
that \code{addNA=} only works in R >= 3.4.0.}

\item{x}{an object of class \code{"freqlist"}}
}
\value{
An object of class \code{"freqlist"} (invisibly for \code{print.freqlist})
}
\description{
Approximate the output from SAS's \code{PROC FREQ} procedure when using the \code{/list} option of the \code{TABLE} statement.
}
\examples{
# load mockstudy data
data(mockstudy)
tab.ex <- table(mockstudy[, c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
summary(noby)
withby <- freqlist(tab.ex, groupBy = c("arm","sex"), na.options = "showexclude")
summary(withby)
}
\seealso{
\code{\link{summary.freqlist}}, \code{\link[base]{table}}, \code{\link[stats]{xtabs}}, \code{\link[knitr]{kable}}
}
\author{
Tina Gunderson, with revisions by Ethan Heinzen
}
