% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableby.control.R
\name{tableby.control}
\alias{tableby.control}
\title{Control settings for \code{tableby} function}
\usage{
tableby.control(
  test = TRUE,
  total = TRUE,
  test.pname = NULL,
  numeric.simplify = FALSE,
  cat.simplify = FALSE,
  ordered.simplify = FALSE,
  date.simplify = FALSE,
  numeric.test = "anova",
  cat.test = "chisq",
  ordered.test = "trend",
  surv.test = "logrank",
  date.test = "kwt",
  test.always = FALSE,
  numeric.stats = c("Nmiss", "meansd", "range"),
  cat.stats = c("Nmiss", "countpct"),
  ordered.stats = c("Nmiss", "countpct"),
  surv.stats = c("Nmiss", "Nevents", "medSurv"),
  date.stats = c("Nmiss", "median", "range"),
  stats.labels = list(Nmiss = "N-Miss", Nmiss2 = "N-Miss", meansd = "Mean (SD)",
    medianrange = "Median (Range)", median = "Median", medianq1q3 = "Median (Q1, Q3)",
    q1q3 = "Q1, Q3", iqr = "IQR", mean = "Mean", sd = "SD", var = "Var", max = "Max", min
    = "Min", meanCI = "Mean (CI)", sum = "Sum", gmean = "Geom Mean", gsd = "Geom SD",
    gmeansd = "Geom Mean (Geom SD)", gmeanCI = "Geom Mean (CI)", range = "Range", Npct =
    "N (Pct)", Nevents = "Events", medSurv = "Median Survival", medTime =
    "Median Follow-Up", medianmad = "Median (MAD)",      overall = "Overall", total =
    "Total", difference = "Difference"),
  digits = 3L,
  digits.count = 0L,
  digits.pct = 1L,
  digits.p = 3L,
  format.p = TRUE,
  digits.n = 0L,
  conf.level = 0.95,
  chisq.correct = FALSE,
  simulate.p.value = FALSE,
  B = 2000,
  times = 1:5,
  ...
)
}
\arguments{
\item{test}{logical, telling \code{tableby} whether to perform tests of x variables across levels of the group variable.}

\item{total}{logical, telling \code{tableby} whether to calculate a column of totals across group variable.}

\item{test.pname}{character string denoting the p-value column name in \code{\link{summary.tableby}}.
Modifiable also with \code{\link{modpval.tableby}}.}

\item{numeric.simplify, date.simplify}{logical, tell \code{tableby} whether to condense numeric/date output to a single line.
NOTE: this only simplifies to one line if there is only one statistic reported, such as \code{meansd}.
In particular, if \code{Nmiss} is specified and there are missings, then the output is not simplified.}

\item{cat.simplify, ordered.simplify}{logical, tell \code{tableby} whether to remove the first level of the categorical/ordinal variable if binary.
If \code{TRUE}, only the summary stats of the second level are reported (unless there's only one level, in which case it's reported).
NOTE: this only simplifies to one line if there is only one statistic reported, such as \code{countpct}.
In particular, if \code{Nmiss} is specified and there are missings, then the output is not simplified.}

\item{numeric.test}{name of test for numeric RHS variables in \code{tableby}: anova, kwt (Kruskal-Wallis).
If no LHS variable exists, then a mean is required for a univariate test.}

\item{cat.test}{name of test for categorical variables: chisq, fe (Fisher's Exact)}

\item{ordered.test}{name of test for ordered variables: trend}

\item{surv.test}{name of test for survival variables: logrank}

\item{date.test}{name of test for date variables: kwt}

\item{test.always}{Should the test be performed even if one or more by-group has 0 observations? Relevant
for kwt and anova.}

\item{numeric.stats}{summary statistics to include for numeric RHS variables within the levels of the group LHS variable.
Options are N, Nmiss, Nmiss2, mean, meansd, median, q1q3, medianq1q3, iqr, range, medianrange, or other R built-in or user-written functions.}

\item{cat.stats}{summary statistics to include for categorical RHS variables within the levels of the group LHS variable.
Options are N, Nmiss, Nmiss2, count, countpct, countrowpct, countcellpct, or other R built-in or user-written functions.}

\item{ordered.stats}{summary statistics to include for categorical RHS variables within the levels of the group LHS variable.
Options are N, Nmiss, count, countpct, or other R built-in or user-written functions.}

\item{surv.stats}{summary statistics to include for time-to-event (survival) RHS variables within the levels of the group LHS variable.
Options are Nevents, medsurv, NeventsSurv, NriskSurv, medTime, rangeTime.}

\item{date.stats}{stats functions to perform for Date variables: Nmiss, median, range, medianrange, q1q3, medianq1q3,
or other R built-in or user-written functions.}

\item{stats.labels}{A named list of labels for all the statistics function names, where the function name is the named element in the list
and the value that goes with it is a string containing the formal name that will be printed in all printed renderings of the output,
e.g., \code{list(countpct="Count (Pct)")}.}

\item{digits}{Number of decimal places for numeric values.}

\item{digits.count}{Number of decimal places for count values.}

\item{digits.pct}{Number of decimal places for percents.}

\item{digits.p}{Number of decimal places for p-values.}

\item{format.p}{Logical, denoting whether to format p-values. See "Details", below.}

\item{digits.n}{Number of decimal places for N's in the header. Set it to NA to suppress the N's.}

\item{conf.level}{Numeric, denoting what confidence level to use for confidence intervals.
(See, e.g., \code{\link{binomCI}})}

\item{chisq.correct}{logical, correction factor for chisq.test}

\item{simulate.p.value}{logical, simulate p-value for categorical tests (fe and chisq)}

\item{B}{number of simulations to perform for simulation-based p-value}

\item{times}{A vector of times to use for survival summaries.}

\item{...}{additional arguments.}
}
\value{
A list with settings to be used within the \code{tableby} function.
}
\description{
Control test and summary settings for the \code{\link{tableby}} function.
}
\details{
All tests can be turned off by setting \code{test} to FALSE.
  Otherwise, test are set to default settings in this list, or set explicitly in the formula of \code{tableby}.

If \code{format.p} is \code{FALSE}, \code{digits.p} denotes the number of significant digits shown. The
  p-values will be in exponential notation if necessary. If \code{format.p} is \code{TRUE},
  \code{digits.p} will determine the number of digits after the decimal point to show. If the p-value
  is less than the resulting number of places, it will be formatted to show so.
}
\examples{
set.seed(100)
## make 3+ categories for Response
mdat <- data.frame(Response=c(0,0,0,0,0,1,1,1,1,1),
                   Sex=sample(c("Male", "Female"), 10,replace=TRUE),
                   Age=round(rnorm(10,mean=40, sd=5)),
                   HtIn=round(rnorm(10,mean=65,sd=5)))

## allow default summaries in RHS variables, and pass control args to
## main function, to be picked up with ... when calling tableby.control
outResp <- tableby(Response ~ Sex + Age + HtIn, data=mdat, total=FALSE, test=TRUE)
outCtl <- tableby(Response ~ Sex + Age + HtIn, data=mdat,
                  control=tableby.control(total=TRUE, cat.simplify=TRUE,
                  cat.stats=c("Nmiss","countpct"),digits=1))
summary(outResp, text=TRUE)
summary(outCtl, text=TRUE)
}
\seealso{
\code{\link[stats]{anova}}, \code{\link[stats]{chisq.test}}, \code{\link{tableby}}, \code{\link{summary.tableby}},
  \code{\link{tableby.stats}}.
}
\author{
Jason Sinnwell, Beth Atkinson, Ethan Heinzen, Terry Therneau, adapted from SAS Macros written by Paul Novotny and Ryan Lennon
}
