% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_range.R
\name{est_power_range_lm}
\alias{est_power_range_lm}
\alias{est_power_range_lmer}
\title{Estimate power for a range of replicates}
\usage{
est_power_range_lm(
  formula,
  variable_list,
  betas,
  sigma_Cq,
  std_curve_alpha,
  std_curve_beta,
  type = c("exclude_zero", "accuracy"),
  rep_range = seq(2, 20, 2),
  accuracy_level = 0.2,
  conf_level = 0.95,
  n_sim = 200L,
  probs = conf_to_probs(conf_level),
  upper_Cq = 40,
  verbose = FALSE
)

est_power_range_lmer(
  formula,
  variable_list,
  betas,
  sigma_Cq,
  sigma_rand,
  std_curve_alpha,
  std_curve_beta,
  type = c("exclude_zero", "accuracy"),
  rep_range = seq(2, 20, 2),
  accuracy_level = 0.2,
  conf_level = 0.95,
  n_sim = 200L,
  probs = conf_to_probs(conf_level),
  upper_Cq = 40,
  verbose = FALSE
)
}
\arguments{
\item{formula}{a model formula, e.g. \code{y ~ x1 + x2}. For
\code{sim_eDNA_lmer}, random intercepts can also be provided,
e.g. \code{ ( 1 | rep ) }.}

\item{variable_list}{a named list, with the levels that each
variable can take.  Please note that the variables listed in
the formula, including the response variable, must be present
in the variable_list or in the X design matrix.  Extra
variables, i.e. variables which do not occur in the formula,
are ignored.}

\item{betas}{numeric vector, the beta for each variable in the
design matrix}

\item{sigma_Cq}{numeric, the measurement error on CQ.}

\item{std_curve_alpha}{the alpha value for the formula for
converting between log(eDNA concentration) and CQ value}

\item{std_curve_beta}{the beta value for the formula for
converting between log(eDNA concentration) and CQ value}

\item{type}{either "exclude_zero" or "accuracy". Exclude_zero give
the classic power estimate, i.e. whether 0 is in the
confidence interval for the estimate ("significant"). Accuracy
measures whether the estimated betas are within some
percentage of the "true" betas used to simulate the data.}

\item{rep_range}{vector, a set of the number of iterations to
calculate the power for}

\item{accuracy_level}{numeric, between 0 and 1. The percent of the
true betas for the accuracy estimate.}

\item{conf_level}{numeric, between 0 and 1, representing the
percent of the confidence interval to calculate. If
\code{probs} is not provided, then the interval is assumed to
be symetric.}

\item{n_sim}{integer, the number of simulations to conduct in
order to estimate the power.}

\item{probs}{probabilities for the calculation of the confidence
intervals. By default, a symetric set of lower and upper
probabilities is constructed by \code{conf_to_probs})}

\item{upper_Cq}{numeric, the upper limit on CQ detection. Any
value of log(concentration) which would result in a value
greater than this limit is instead recorded as the limit.}

\item{verbose}{logical, when TRUE output from
\code{rstan::sampling} is written to the console.}

\item{sigma_rand}{numeric vector, the stdev for the random
effects. There must be one sigma per random effect specified}
}
\value{
list, with each element a vector for the estimated power
    for each parameter for the corresponding number of replicates.
}
\description{
Estimate power for range of reps.
}
\details{
This function estimates power for an eDNA sampling study for a
range of potential reps.
}
\author{
Matt Espe
}
