% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.significant.R
\name{is.significant}
\alias{is.significant}
\alias{is.significant,rules-method}
\title{Find Significant Rules}
\usage{
is.significant(
  x,
  transactions,
  method = "fisher",
  alpha = 0.01,
  adjust = "bonferroni"
)

\S4method{is.significant}{rules}(
  x,
  transactions,
  method = "fisher",
  alpha = 0.01,
  adjust = "bonferroni"
)
}
\arguments{
\item{x}{a set of \link{rules}.}

\item{transactions}{set of \link{transactions} used to mine the rules.}

\item{method}{test to use. Options are \code{"fisher"}, \code{"chisq"}. Note that
the contingency table is likely to have cells with low expected values and
that thus Fisher's Exact Test might be more appropriate than the chi-squared
test.}

\item{alpha}{required significance level.}

\item{adjust}{method to adjust for multiple comparisons. Options are
\code{"none"}, \code{"bonferroni"}, \code{"holm"}, \code{"fdr"}, etc. (see
\code{\link[stats:p.adjust]{stats::p.adjust()}})}
}
\value{
returns a logical vector indicating which rules are significant.
}
\description{
Provides the generic functions \code{is.significant()} and the method to
find significant \link{rules}.
}
\details{
The implementation for association rules uses Fisher's exact test with
correction for multiple comparisons to test the null hypothesis that the LHS
and the RHS of the rule are independent.  Significant rules have a p-value
less then the specified significance level alpha (the null hypothesis of
independence is rejected). See Hahsler and Hornik (2007) for details.
}
\examples{
data("Income")
rules <- apriori(Income, parameter = list(support = 0.5))
is.significant(rules, Income)

inspect(rules[is.significant(rules, Income)])
}
\references{
Hahsler, Michael and Kurt Hornik (2007). New probabilistic
interest measures for association rules. \emph{Intelligent Data Analysis},
11(5):437--455.
\doi{10.3233/IDA-2007-11502}
}
\seealso{
\code{\link[stats:p.adjust]{stats::p.adjust()}}

Other interest measures: 
\code{\link{confint}()},
\code{\link{coverage}()},
\code{\link{interestMeasure}()},
\code{\link{is.redundant}()},
\code{\link{support}()}

Other postprocessing: 
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.superset}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{interest measures}
\concept{postprocessing}
\keyword{manip}
