selftest.H0.tck <- function(){
  options(guiToolkit="tcltk")
  w <- gwindow(title = "Null hypotheses")
  size(w) <- c(700, 500)
  g <- ggroup(container=w, horizontal=FALSE, use.scrollwindow = TRUE)
  q1 <- gexpandgroup("Question 1", container=g, anchor=c(-1,1))
  q2 <- gexpandgroup("Question 2", container=g, anchor=c(-1,1))
  q3 <- gexpandgroup("Question 3", container=g, anchor=c(-1,1))
  q4 <- gexpandgroup("Question 4", container=g, anchor=c(-1,1))
  q5 <- gexpandgroup("Question 5", container=g, anchor=c(-1,1))
  q6 <- gexpandgroup("Question 6", container=g, anchor=c(-1,1))
  
  #------------- Question 1 -----------#
  gp1 <- ggroup(container = q1, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("I reject H\u2080 but H\u2080 is true.  This is a...", container = gp1, anchor = c(-1,1))
  addSpace(gp1, .5, horizontal=FALSE)
  ans1 <- c("(a)     Type I error.",
            "(b)     Type II error.",
            "(c)     Type III error.",
            "(d)     None of the above.")

  r1 <- gcheckboxgroup(ans1, container = gp1, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r1, handler = function(h,....){
    if(tail(svalue(r1),1) == ans1[1]){
      gmessage(message="Correct")
    }
    if(tail(svalue(r1),1)== ans1[2]){
      gmessage(message="Incorrect", icon = "error")
    }
    if(tail(svalue(r1),1)== ans1[3]){
      gmessage(message="Incorrect", icon = "error")
    }
    if(tail(svalue(r1),1)== ans1[4]){
      gmessage(message="Incorrect", icon = "error")
    }
    svalue(r1) <- character(0)
  })
  
  
  #------------- Question 2 -----------#
  gp2 <- ggroup(container = q2, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("We suspect that a soil N treatment will increase mean plant biomass compared to a control.  \nWhat would our alternative hypothesis be?", container = gp2, anchor = c(-1,1))
  addSpace(gp2, .5, horizontal=FALSE)
  ans2 <- c("(a) \u03BCN < \u03BCControl.",
            "(b) \u03BCN > \u03BCControl.",
            "(c) \u03BCN = \u03BCControl.",
            "(d) \u03BCN \u2260 \u03BCControl.")
  
  r2 <- gcheckboxgroup(ans2, container = gp2, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r2, handler = function(h,....){
    if(tail(svalue(r2),1) == ans2[1]){
      gmessage(message="Incorrect", icon = "error")
    }
    if(tail(svalue(r2),1)== ans2[2]){
      gmessage(message="Correct")
    }
    if(tail(svalue(r2),1)== ans2[3]){
      gmessage(message="Incorrect", icon = "error")
    }
    if(tail(svalue(r2),1)== ans2[4]){
      gmessage(message="Incorrect", icon = "error")
    }
    svalue(r2) <- character(0)
  })
  
  #------------- Question 3 -----------#
  
  gp3 <- ggroup(container = q3, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("Statistical power is...",
         container = gp3, anchor = c(-1,1))
  addSpace(gp3, .5, horizontal=FALSE)
  ans3 <- c("(a)  1 - the probability of type I error",
            "(b)  1 - \u03B1\u00B2",
            "(c)  1 - the probability of type II error",
            "(d)  1/\u03B1")
  
  r3 <- gcheckboxgroup(ans3, container = gp3, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r3, handler = function(h,....){
    if(tail(svalue(r3),1) == ans3[1]){
      gmessage(message="Incorrect",  icon = "error")
    }
    if(tail(svalue(r3),1)== ans3[2]){
      gmessage(message="Incorrect",  icon = "error")
    }
    if(tail(svalue(r3),1)== ans3[3]){
      gmessage(message="Correct")
    }
    if(tail(svalue(r3),1)== ans3[4]){
      gmessage(message="Incorrect",  icon = "error")
    }
    svalue(r3) <- character(0)
  })
  
  #------------- Question 4 -----------#
  
  gp4 <- ggroup(container = q4, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("(T or F) A P-value requires a null hypothesis.",
         container = gp4, anchor = c(-1,1))
  addSpace(gp4, .5, horizontal=FALSE)
  ans4 <- c("T",
            "F")
  
  r4 <- gcheckboxgroup(ans4, container = gp4, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r4, handler = function(h,....){
    if(tail(svalue(r4),1) == ans4[1]){
      gmessage(message="Correct")
    }
    if(tail(svalue(r4),1)== ans4[2]){
      gmessage(message="Incorrect",  icon = "error")
    }
    svalue(r4) <- character(0)
    
  })
  
  #------------- Question 5 -----------#
  
  gp5 <- ggroup(container = q5, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("A P-value is...",
         container = gp5, anchor = c(-1,1))
  addSpace(gp5, .5, horizontal=FALSE)
  ans5 <- c("(a)  The probability that the null hypothesis is true.",
            "(b)  The probability that the null hypothesis is false.",
            "(c)  The probability that the alternative hypothesis is false.",
            "(d)  P(data|H\u2080)")
  
  r5 <- gcheckboxgroup(ans5, container = gp5, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r5, handler = function(h,....){
    if(tail(svalue(r5),1) == ans5[1]){
      gmessage(message="Incorrect",  icon = "error")
    }
    if(tail(svalue(r5),1)== ans5[2]){
      gmessage(message="Incorrect",  icon = "error")
    }
    if(tail(svalue(r5),1)== ans5[3]){
      gmessage(message="Incorrect",  icon = "error")
    }
    if(tail(svalue(r5),1)== ans5[4]){
      gmessage(message="Correct")
    }
    svalue(r5) <- character(0)
  })
  
  
  #------------- Question 6 -----------#
  
  gp6 <- ggroup(container = q6, spacing = 2, pos = 0, horizontal = FALSE)
  glabel("Which of the following constitute a criticism of H\u2080 hypothesis testing?",
         container = gp6, anchor = c(-1,1))
  addSpace(gp6, .5, horizontal=FALSE)
  ans6 <- c("(a)  The sample space for the H\u2080 distribution may exceed what can be sampled.",
            "(b)  P-values represent P(data|H\u2080) not P(H\u2080|data).",
            "(c)  Evidence against H\u2080 may not imply evidence for the alternative.",
            "(d)  Significance levels (in significance testing) are arbitrary",
            "(e)  P-values are partially a function of sample size.",
            "(f)  All of the above.")
            
  
  r6 <- gcheckboxgroup(ans6, container = gp6, checked = FALSE, where = "beginning")
  
  
  addhandlerclicked(r6, handler = function(h,....){
    if(tail(svalue(r6),1) == ans6[1]){
      gmessage(message="Partially correct",  icon = "error")
    }
    if(tail(svalue(r6),1)== ans6[2]){
      gmessage(message="Partially correct",  icon = "error")
    }
    if(tail(svalue(r6),1)== ans6[3]){
      gmessage(message="Partially correct",  icon = "error")
    }
    if(tail(svalue(r6),1)== ans6[4]){
      gmessage(message="Partially correct",  icon = "error")
    }
    if(tail(svalue(r6),1)== ans6[5]){
      gmessage(message="Partially correct",  icon = "error")
    }
    if(tail(svalue(r6),1)== ans6[6]){
      gmessage(message="Correct")
    }
    svalue(r6) <- character(0)
  })
}